/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.convert;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;

public class StringArrayConverter
implements Converter {
    public Object getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        try {
            StringTokenizer tokenizer = new StringTokenizer(value, ",");
            String[] newValue = new String[tokenizer.countTokens()];
            int i = 0;
            while (tokenizer.hasMoreTokens()) {
                newValue[i] = URLDecoder.decode(tokenizer.nextToken(), "UTF-8");
                ++i;
            }
            return newValue;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        return StringArrayConverter.getAsString((String[])value, true);
    }

    public static String getAsString(String[] strings, boolean escapeCommas) {
        try {
            if (strings == null || strings.length == 0) {
                return null;
            }
            if (strings.length == 1) {
                return escapeCommas ? URLEncoder.encode(strings[0], "UTF-8") : strings[0];
            }
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < strings.length) {
                if (i > 0) {
                    buf.append(',');
                }
                String s = strings[i];
                if (escapeCommas) {
                    s = URLEncoder.encode(s, "UTF-8");
                }
                buf.append(s);
                ++i;
            }
            return buf.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

