/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.tree;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlPanelGroup;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.component.html.util.AddResource;
import org.apache.myfaces.custom.tree.HtmlTreeNode;
import org.apache.myfaces.custom.tree.IconProvider;
import org.apache.myfaces.custom.tree.event.TreeSelectionEvent;
import org.apache.myfaces.custom.tree.event.TreeSelectionListener;
import org.apache.myfaces.custom.tree.model.TreeModel;
import org.apache.myfaces.custom.tree.model.TreeModelEvent;
import org.apache.myfaces.custom.tree.model.TreeModelListener;
import org.apache.myfaces.custom.tree.model.TreePath;

public class HtmlTree
extends HtmlPanelGroup
implements TreeModelListener {
    public static final int DEFAULT_EXPIRE_LISTENERS = 28800000;
    private static final String FACET_ROOTNODE = "rootNode";
    private static final String PREVIOUS_VIEW_ROOT = (class$org$apache$myfaces$custom$tree$HtmlTree == null ? (class$org$apache$myfaces$custom$tree$HtmlTree = HtmlTree.class$("org.apache.myfaces.custom.tree.HtmlTree")) : class$org$apache$myfaces$custom$tree$HtmlTree).getName() + ".PREVIOUS_VIEW_ROOT";
    private static final int EVENT_CHANGED = 0;
    private static final int EVENT_INSERTED = 1;
    private static final int EVENT_REMOVED = 2;
    private static final int EVENT_STRUCTURE_CHANGED = 3;
    private static int counter = 0;
    private static final String DEFAULT_IMAGE_ICON_LINE = "images/line.gif";
    private static final String DEFAULT_IMAGE_ICON_NOLINE = "images/noline.gif";
    private static final String DEFAULT_IMAGE_ICON_CHILD_FIRST = "images/line_first.gif";
    private static final String DEFAULT_IMAGE_ICON_CHILD_MIDDLE = "images/line_middle.gif";
    private static final String DEFAULT_IMAGE_ICON_CHILD_LAST = "images/line_last.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_OPEN = "images/node_open.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_OPEN_FIRST = "images/node_open_first.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_OPEN_MIDDLE = "images/node_open_middle.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_OPEN_LAST = "images/node_open_last.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_CLOSE = "images/node_close.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_CLOSE_FIRST = "images/node_close_first.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_CLOSE_MIDDLE = "images/node_close_middle.gif";
    private static final String DEFAULT_IMAGE_ICON_NODE_CLOSE_LAST = "images/node_close_last.gif";
    private IconProvider iconProvider;
    private boolean itemStatesRestored = false;
    private String var;
    private String styleClass;
    private String nodeClass;
    private String rowClasses;
    private String columnClasses;
    private String selectedNodeClass;
    private String iconClass;
    private String iconLine;
    private String iconNoline;
    private String iconChildFirst;
    private String iconChildMiddle;
    private String iconChildLast;
    private String iconNodeOpen;
    private String iconNodeOpenFirst;
    private String iconNodeOpenMiddle;
    private String iconNodeOpenLast;
    private String iconNodeClose;
    private String iconNodeCloseFirst;
    private String iconNodeCloseMiddle;
    private String iconNodeCloseLast;
    private int uniqueIdCounter = 0;
    private int[] selectedPath;
    private int internalId = counter++;
    private long expireListeners = 28800000L;
    static /* synthetic */ Class class$org$apache$myfaces$custom$tree$HtmlTree;

    public TreeModel getModel(FacesContext context) {
        TreeModel model;
        ValueBinding binding = this.getValueBinding("model");
        if (binding != null && (model = (TreeModel)binding.getValue(context)) != null) {
            return model;
        }
        return null;
    }

    public String createUniqueId(FacesContext context) {
        return this.getClientId(context).replaceAll(":", "_") + "_node_" + this.uniqueIdCounter++;
    }

    public void addTreeSelectionListener(TreeSelectionListener listener) {
        this.addFacesListener(listener);
    }

    public IconProvider getIconProvider() {
        return this.iconProvider;
    }

    public void setIconProvider(IconProvider iconProvider) {
        this.iconProvider = iconProvider;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getIconLine() {
        if (this.iconLine != null) {
            return this.iconLine;
        }
        return HtmlTree.getDefaultImagePath(DEFAULT_IMAGE_ICON_LINE);
    }

    public void setIconLine(String iconLine) {
        this.iconLine = iconLine;
    }

    public String getIconNoline() {
        if (this.iconNoline != null) {
            return this.iconNoline;
        }
        return HtmlTree.getDefaultImagePath(DEFAULT_IMAGE_ICON_NOLINE);
    }

    public void setIconNoline(String iconNoline) {
        this.iconNoline = iconNoline;
    }

    public String getIconChildFirst() {
        if (this.iconChildFirst != null) {
            return this.iconChildFirst;
        }
        return HtmlTree.getDefaultImagePath(DEFAULT_IMAGE_ICON_CHILD_FIRST);
    }

    public void setIconChildFirst(String iconChildFirst) {
        this.iconChildFirst = iconChildFirst;
    }

    public String getIconChildMiddle() {
        if (this.iconChildMiddle != null) {
            return this.iconChildMiddle;
        }
        return HtmlTree.getDefaultImagePath(DEFAULT_IMAGE_ICON_CHILD_MIDDLE);
    }

    public void setIconChildMiddle(String iconChildMiddle) {
        this.iconChildMiddle = iconChildMiddle;
    }

    public String getIconChildLast() {
        if (this.iconChildLast != null) {
            return this.iconChildLast;
        }
        return HtmlTree.getDefaultImagePath(DEFAULT_IMAGE_ICON_CHILD_LAST);
    }

    public void setIconChildLast(String iconChildLast) {
        this.iconChildLast = iconChildLast;
    }

    public String getIconNodeOpen() {
        if (this.iconNodeOpen != null) {
            return this.iconNodeOpen;
        }
        return HtmlTree.getDefaultImagePath(DEFAULT_IMAGE_ICON_NODE_OPEN);
    }

    public void setIconNodeOpen(String iconNodeOpen) {
        this.iconNodeOpen = iconNodeOpen;
    }

    public String getIconNodeOpenFirst() {
        if (this.iconNodeOpenFirst != null) {
            return this.iconNodeOpenFirst;
        }
        return HtmlTree.getDefaultImagePath(DEFAULT_IMAGE_ICON_NODE_OPEN_FIRST);
    }

    public void setIconNodeOpenFirst(String iconNodeOpenFirst) {
        this.iconNodeOpenFirst = iconNodeOpenFirst;
    }

    public String getIconNodeOpenMiddle() {
        if (this.iconNodeOpenMiddle != null) {
            return this.iconNodeOpenMiddle;
        }
        return HtmlTree.getDefaultImagePath(DEFAULT_IMAGE_ICON_NODE_OPEN_MIDDLE);
    }

    public void setIconNodeOpenMiddle(String iconNodeOpenMiddle) {
        this.iconNodeOpenMiddle = iconNodeOpenMiddle;
    }

    public String getIconNodeOpenLast() {
        if (this.iconNodeOpenLast != null) {
            return this.iconNodeOpenLast;
        }
        return HtmlTree.getDefaultImagePath(DEFAULT_IMAGE_ICON_NODE_OPEN_LAST);
    }

    public void setIconNodeOpenLast(String iconNodeOpenLast) {
        this.iconNodeOpenLast = iconNodeOpenLast;
    }

    public String getIconNodeClose() {
        if (this.iconNodeClose != null) {
            return this.iconNodeClose;
        }
        return HtmlTree.getDefaultImagePath(DEFAULT_IMAGE_ICON_NODE_CLOSE);
    }

    public void setIconNodeClose(String iconNodeClose) {
        this.iconNodeClose = iconNodeClose;
    }

    public String getIconNodeCloseFirst() {
        if (this.iconNodeCloseFirst != null) {
            return this.iconNodeCloseFirst;
        }
        return HtmlTree.getDefaultImagePath(DEFAULT_IMAGE_ICON_NODE_CLOSE_FIRST);
    }

    public void setIconNodeCloseFirst(String iconNodeCloseFirst) {
        this.iconNodeCloseFirst = iconNodeCloseFirst;
    }

    public String getIconNodeCloseMiddle() {
        if (this.iconNodeCloseMiddle != null) {
            return this.iconNodeCloseMiddle;
        }
        return HtmlTree.getDefaultImagePath(DEFAULT_IMAGE_ICON_NODE_CLOSE_MIDDLE);
    }

    public void setIconNodeCloseMiddle(String iconNodeCloseMiddle) {
        this.iconNodeCloseMiddle = iconNodeCloseMiddle;
    }

    public String getIconNodeCloseLast() {
        if (this.iconNodeCloseLast != null) {
            return this.iconNodeCloseLast;
        }
        return HtmlTree.getDefaultImagePath(DEFAULT_IMAGE_ICON_NODE_CLOSE_LAST);
    }

    public void setIconNodeCloseLast(String iconNodeCloseLast) {
        this.iconNodeCloseLast = iconNodeCloseLast;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getNodeClass() {
        return this.nodeClass;
    }

    public void setNodeClass(String nodeClass) {
        this.nodeClass = nodeClass;
    }

    public String getRowClasses() {
        return this.rowClasses;
    }

    public void setRowClasses(String rowClasses) {
        this.rowClasses = rowClasses;
    }

    public String getColumnClasses() {
        return this.columnClasses;
    }

    public void setColumnClasses(String columnClasses) {
        this.columnClasses = columnClasses;
    }

    public String getSelectedNodeClass() {
        return this.selectedNodeClass;
    }

    public void setSelectedNodeClass(String selectedNodeClass) {
        this.selectedNodeClass = selectedNodeClass;
    }

    public String getIconClass() {
        return this.iconClass;
    }

    public void setIconClass(String iconClass) {
        this.iconClass = iconClass;
    }

    public long getExpireListeners() {
        return this.expireListeners;
    }

    public void setExpireListeners(long expireListeners) {
        this.expireListeners = expireListeners;
    }

    public String getFamily() {
        return "org.apache.myfaces.HtmlTree";
    }

    public void expandPath(TreePath path, FacesContext context) {
        TreeModel model = this.getModel(context);
        if (path != null && model != null && !model.isLeaf(path.getLastPathComponent())) {
            int[] translatedPath = HtmlTreeNode.translatePath(path, this.getModel(context));
            HtmlTreeNode rootNode = this.getRootNode();
            if (rootNode == null) {
                this.createRootNode(context);
                rootNode = this.getRootNode();
            }
            if (!rootNode.isExpanded()) {
                rootNode.setExpanded(true);
            }
            rootNode.expandPath(translatedPath, 0);
        }
    }

    public void collapsePath(TreePath path, FacesContext context) {
        HtmlTreeNode node = this.findNode(path, context);
        if (node != null) {
            node.setExpanded(false);
        }
    }

    public boolean isExpanded(TreePath path, FacesContext context) {
        if (path == null) {
            return false;
        }
        return this.findNode(path, context) != null;
    }

    private HtmlTreeNode findNode(TreePath path, FacesContext context) {
        HtmlTreeNode node = this.getRootNode();
        int[] translatedPath = HtmlTreeNode.translatePath(path, this.getModel(context));
        int i = 0;
        while (i < translatedPath.length) {
            if (!node.isExpanded()) {
                return null;
            }
            int index = translatedPath[i];
            node = (HtmlTreeNode)node.getChildren().get(index);
            ++i;
        }
        return node;
    }

    public TreePath getSelectionPath() {
        if (this.selectedPath == null) {
            return null;
        }
        return HtmlTreeNode.translatePath(this.selectedPath, this.getModel(FacesContext.getCurrentInstance()));
    }

    public void selectionChanged(HtmlTreeNode node) {
        TreePath oldPath = null;
        if (this.selectedPath != null) {
            oldPath = HtmlTreeNode.translatePath(this.selectedPath, this.getModel(FacesContext.getCurrentInstance()));
        }
        this.selectedPath = node.getTranslatedPath();
        if (node.isSelected()) {
            this.queueEvent(new TreeSelectionEvent(this, oldPath, node.getPath()));
        } else {
            this.queueEvent(new TreeSelectionEvent(this, oldPath, null));
        }
    }

    private void createRootNode(FacesContext context) {
        TreeModel model = this.getModel(context);
        Object root = model.getRoot();
        HtmlTreeNode node = (HtmlTreeNode)context.getApplication().createComponent("org.apache.myfaces.HtmlTreeNode");
        String id = this.createUniqueId(context);
        node.setId(id);
        node.setPath(new TreePath(new Object[]{root}));
        node.setUserObject(root);
        node.setLayout(new int[]{13});
        this.getFacets().put(FACET_ROOTNODE, node);
    }

    public HtmlTreeNode getRootNode() {
        return (HtmlTreeNode)this.getFacet(FACET_ROOTNODE);
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.iconChildFirst, this.iconChildMiddle, this.iconChildLast, this.iconLine, this.iconNodeClose, this.iconNodeCloseFirst, this.iconNodeCloseLast, this.iconNodeCloseMiddle, this.iconNodeOpen, this.iconNodeOpenFirst, this.iconNodeOpenLast, this.iconNodeOpenMiddle, this.iconNoline, this.styleClass, this.nodeClass, this.selectedNodeClass, new Integer(this.uniqueIdCounter), this.selectedPath, this.iconClass, new Integer(this.internalId), new Long(this.expireListeners), this.rowClasses, this.columnClasses, this.var};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.iconChildFirst = (String)values[1];
        this.iconChildMiddle = (String)values[2];
        this.iconChildLast = (String)values[3];
        this.iconLine = (String)values[4];
        this.iconNodeClose = (String)values[5];
        this.iconNodeCloseFirst = (String)values[6];
        this.iconNodeCloseLast = (String)values[7];
        this.iconNodeCloseMiddle = (String)values[8];
        this.iconNodeOpen = (String)values[9];
        this.iconNodeOpenFirst = (String)values[10];
        this.iconNodeOpenLast = (String)values[11];
        this.iconNodeOpenMiddle = (String)values[12];
        this.iconNoline = (String)values[13];
        this.styleClass = (String)values[14];
        this.nodeClass = (String)values[15];
        this.selectedNodeClass = (String)values[16];
        this.uniqueIdCounter = (Integer)values[17];
        this.selectedPath = (int[])values[18];
        this.iconClass = (String)values[19];
        this.internalId = (Integer)values[20];
        this.expireListeners = (Long)values[21];
        this.rowClasses = (String)values[22];
        this.columnClasses = (String)values[23];
        this.var = (String)values[24];
        this.addToModelListeners();
    }

    public void decode(FacesContext context) {
        super.decode(context);
        context.getExternalContext().getRequestMap().put(PREVIOUS_VIEW_ROOT, context.getViewRoot());
        this.itemStatesRestored = true;
    }

    public void processDecodes(FacesContext context) {
        this.addToModelListeners();
        super.processDecodes(context);
    }

    public void processValidators(FacesContext context) {
        this.addToModelListeners();
        super.processValidators(context);
    }

    public void processUpdates(FacesContext context) {
        this.addToModelListeners();
        super.processUpdates(context);
    }

    public void encodeBegin(FacesContext context) throws IOException {
        UIViewRoot previousRoot;
        this.addToModelListeners();
        this.processModelEvents();
        HtmlTreeNode node = this.getRootNode();
        if (node == null) {
            this.createRootNode(context);
        }
        if (!this.itemStatesRestored && (previousRoot = (UIViewRoot)context.getExternalContext().getRequestMap().get(PREVIOUS_VIEW_ROOT)) != null) {
            this.restoreItemStates(context, previousRoot);
        }
        super.encodeBegin(context);
    }

    public void encodeEnd(FacesContext context) throws IOException {
        super.encodeEnd(context);
    }

    public void restoreItemStates(FacesContext facesContext, UIViewRoot previousRoot) {
        HtmlTree previousTree = (HtmlTree)previousRoot.findComponent(this.getClientId(facesContext));
        if (previousTree != null) {
            HtmlTreeNode node = previousTree.getRootNode();
            if (node != null) {
                this.getRootNode().restoreItemState(node);
            }
            this.selectedPath = previousTree.selectedPath;
        }
    }

    public void treeNodesChanged(TreeModelEvent e) {
        FacesContext context;
        TreePath path = e.getTreePath();
        HtmlTreeNode node = this.findNode(path, context = FacesContext.getCurrentInstance());
        if (node != null) {
            node.childrenChanged(e.getChildIndices(), context);
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
        FacesContext context;
        TreePath path = e.getTreePath();
        HtmlTreeNode node = this.findNode(path, context = FacesContext.getCurrentInstance());
        if (node != null) {
            node.childrenAdded(e.getChildIndices(), context);
        }
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        FacesContext context;
        TreePath path = e.getTreePath();
        HtmlTreeNode node = this.findNode(path, context = FacesContext.getCurrentInstance());
        if (node != null) {
            node.childrenRemoved(e.getChildIndices());
        }
    }

    public void treeStructureChanged(TreeModelEvent e) {
        FacesContext context;
        TreePath path = e.getTreePath();
        if (this.isExpanded(path, context = FacesContext.getCurrentInstance())) {
            this.collapsePath(path, context);
            this.expandPath(path, context);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HtmlTree)) {
            return false;
        }
        HtmlTree other = (HtmlTree)obj;
        return other.getId().equals(this.getId());
    }

    public int hashCode() {
        return this.getClientId(FacesContext.getCurrentInstance()).hashCode();
    }

    public void addToModelListeners() {
        Collection listeners = this.getModel(FacesContext.getCurrentInstance()).getTreeModelListeners();
        long currentTime = System.currentTimeMillis();
        boolean found = false;
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ModelListener listener = (ModelListener)iterator.next();
            if (listener.getId() == this.internalId) {
                found = true;
                continue;
            }
            if (currentTime - listener.getLastAccessTime() <= this.expireListeners) continue;
            iterator.remove();
        }
        if (!found) {
            listeners.add(new ModelListener(this.internalId));
        }
    }

    private void processModelEvents() {
        Collection listeners = this.getModel(FacesContext.getCurrentInstance()).getTreeModelListeners();
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            ModelListener listener = (ModelListener)iterator.next();
            if (listener.getId() != this.internalId) continue;
            Iterator events = listener.getEvents().iterator();
            while (events.hasNext()) {
                Event event = (Event)events.next();
                event.process(this);
                events.remove();
            }
            break block0;
        }
    }

    public void collapseAll() {
        HtmlTreeNode root = this.getRootNode();
        FacesContext context = FacesContext.getCurrentInstance();
        this.collapsePath(root.getPath(), context);
        int i = 0;
        while (i < root.getChildren().size()) {
            HtmlTreeNode child = (HtmlTreeNode)root.getChildren().get(i);
            this.collapsePath(child.getPath(), context);
            if (!child.isLeaf(context)) {
                this.collapseChildren(context, child);
            }
            ++i;
        }
    }

    private void collapseChildren(FacesContext context, HtmlTreeNode parent) {
        int i = 0;
        while (i < parent.getChildren().size()) {
            HtmlTreeNode child = (HtmlTreeNode)parent.getChildren().get(i);
            this.collapsePath(child.getPath(), context);
            if (!child.isLeaf(context)) {
                this.collapseChildren(context, child);
            }
            ++i;
        }
    }

    public void expandAll() {
        HtmlTreeNode root = this.getRootNode();
        FacesContext context = FacesContext.getCurrentInstance();
        this.expandPath(root.getPath(), context);
        int i = 0;
        while (i < root.getChildren().size()) {
            HtmlTreeNode child = (HtmlTreeNode)root.getChildren().get(i);
            this.expandPath(child.getPath(), context);
            if (!child.isLeaf(context)) {
                this.expandChildren(context, child);
            }
            ++i;
        }
    }

    private void expandChildren(FacesContext context, HtmlTreeNode parent) {
        int i = 0;
        while (i < parent.getChildren().size()) {
            HtmlTreeNode child = (HtmlTreeNode)parent.getChildren().get(i);
            this.expandPath(child.getPath(), context);
            if (!child.isLeaf(context)) {
                this.expandChildren(context, child);
            }
            ++i;
        }
    }

    public static String getDefaultImagePath(String relativePathInResourceFolder) {
        return AddResource.getResourceMappedPath(class$org$apache$myfaces$custom$tree$HtmlTree == null ? (class$org$apache$myfaces$custom$tree$HtmlTree = HtmlTree.class$("org.apache.myfaces.custom.tree.HtmlTree")) : class$org$apache$myfaces$custom$tree$HtmlTree, relativePathInResourceFolder, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Event {
        private int kind;
        private TreeModelEvent event;

        public Event(int kind, TreeModelEvent event) {
            this.kind = kind;
            this.event = event;
        }

        public void process(HtmlTree tree) {
            switch (this.kind) {
                case 0: {
                    tree.treeNodesChanged(this.event);
                    break;
                }
                case 1: {
                    tree.treeNodesInserted(this.event);
                    break;
                }
                case 2: {
                    tree.treeNodesRemoved(this.event);
                    break;
                }
                case 3: {
                    tree.treeStructureChanged(this.event);
                }
            }
        }
    }

    private static class ModelListener
    implements TreeModelListener {
        private long lastAccessTime = System.currentTimeMillis();
        private LinkedList events = new LinkedList();
        int id;

        public ModelListener(int id) {
            this.id = id;
        }

        public List getEvents() {
            this.lastAccessTime = System.currentTimeMillis();
            return this.events;
        }

        public int getId() {
            return this.id;
        }

        public long getLastAccessTime() {
            return this.lastAccessTime;
        }

        public void treeNodesChanged(TreeModelEvent e) {
            this.events.addLast(new Event(0, e));
        }

        public void treeNodesInserted(TreeModelEvent e) {
            this.events.addLast(new Event(1, e));
        }

        public void treeNodesRemoved(TreeModelEvent e) {
            this.events.addLast(new Event(2, e));
        }

        public void treeStructureChanged(TreeModelEvent e) {
            this.events.addLast(new Event(3, e));
        }
    }
}

