/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.component;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import javax.faces.event.PhaseId;

public class S2UIViewRoot
extends UIViewRoot {
    private int uniqueIdCounter = 0;
    private List events = null;

    public void queueEvent(FacesEvent event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        if (this.events == null) {
            this.events = new ArrayList();
        }
        this.events.add(event);
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        super.processDecodes(context);
        this.broadcastForPhase(PhaseId.APPLY_REQUEST_VALUES);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        super.processValidators(context);
        this.broadcastForPhase(PhaseId.PROCESS_VALIDATIONS);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        super.processUpdates(context);
        this.broadcastForPhase(PhaseId.UPDATE_MODEL_VALUES);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void processApplication(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        this.broadcastForPhase(PhaseId.INVOKE_APPLICATION);
        if (context.getRenderResponse() || context.getResponseComplete()) {
            this.clearEvents();
        }
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.uniqueIdCounter = 0;
        this.clearEvents();
        super.encodeBegin(context);
    }

    public String createUniqueId() {
        return "_id" + this.uniqueIdCounter++;
    }

    protected void broadcastForPhase(PhaseId phaseId) {
        if (this.events == null) {
            return;
        }
        int phaseIdOrdinal = phaseId.getOrdinal();
        Iterator i = this.events.iterator();
        while (i.hasNext()) {
            FacesEvent event = (FacesEvent)i.next();
            int ordinal = event.getPhaseId().getOrdinal();
            if (ordinal != PhaseId.ANY_PHASE.getOrdinal() && ordinal != phaseIdOrdinal) continue;
            UIComponent source = event.getComponent();
            try {
                try {
                    source.broadcast(event);
                }
                finally {
                    i.remove();
                }
            }
            catch (AbortProcessingException e) {
                this.clearEvents();
                break;
            }
        }
    }

    protected void clearEvents() {
        this.events = null;
    }

    public int getEventSize() {
        if (this.events != null) {
            return this.events.size();
        }
        return 0;
    }
}

