/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.runtime;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.seasar.framework.util.FileInputStreamUtil;
import org.seasar.framework.util.InputStreamUtil;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.TagProcessorTreeFactory;
import org.seasar.jsf.ViewTemplate;
import org.seasar.jsf.ViewTemplateFactory;
import org.seasar.jsf.exception.PathNotFoundRuntimeException;
import org.seasar.jsf.runtime.ViewTemplateImpl;

public class ViewTemplateFactoryImpl
implements ViewTemplateFactory {
    private TagProcessorTreeFactory tagProcessorTreeFactory;
    private ServletContext servletContext;
    private Map viewTemplates = new HashMap();

    public ViewTemplateFactoryImpl(TagProcessorTreeFactory tagProcessorTreeFactory, ServletContext servletContext) {
        this.tagProcessorTreeFactory = tagProcessorTreeFactory;
        this.servletContext = servletContext;
    }

    public synchronized ViewTemplate getViewTemplate(String path) {
        File file;
        String realPath = this.servletContext.getRealPath(path);
        if (realPath != null && (file = new File(realPath)).exists()) {
            return this.getViewTemplateFromRealPath(path, file);
        }
        return this.getViewTemplateFromResource(path);
    }

    protected ViewTemplate getViewTemplateFromRealPath(String path, File file) {
        ViewTemplate template = (ViewTemplate)this.viewTemplates.get(path);
        if (template != null && !template.isModified()) {
            return template;
        }
        TagProcessor rootTagProcessor = null;
        BufferedInputStream is = new BufferedInputStream(FileInputStreamUtil.create((File)file));
        try {
            rootTagProcessor = this.tagProcessorTreeFactory.createTagProcessorTree(is);
        }
        finally {
            InputStreamUtil.close((InputStream)is);
        }
        template = new ViewTemplateImpl(rootTagProcessor, file);
        this.viewTemplates.put(path, template);
        return template;
    }

    protected ViewTemplate getViewTemplateFromResource(String path) {
        ViewTemplate template = (ViewTemplate)this.viewTemplates.get(path);
        if (template != null) {
            return template;
        }
        TagProcessor rootTagProcessor = null;
        InputStream is = this.servletContext.getResourceAsStream(path);
        if (is == null) {
            throw new PathNotFoundRuntimeException(path);
        }
        try {
            rootTagProcessor = this.tagProcessorTreeFactory.createTagProcessorTree(is);
        }
        finally {
            InputStreamUtil.close((InputStream)is);
        }
        template = new ViewTemplateImpl(rootTagProcessor);
        this.viewTemplates.put(path, template);
        return template;
    }
}

