/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.application;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import org.apache.myfaces.util.ClassUtils;

public class TreeStructureManager {
    public Object buildTreeStructureToSave(UIViewRoot viewRoot) {
        return this.internalBuildTreeStructureToSave(viewRoot);
    }

    private TreeStructComponent internalBuildTreeStructureToSave(UIComponent component) {
        Map facetMap;
        UIComponent child;
        TreeStructComponent structComp = new TreeStructComponent(component.getClass().getName(), component.getId());
        if (component.getChildCount() > 0) {
            List childList = component.getChildren();
            ArrayList<TreeStructComponent> structChildList = new ArrayList<TreeStructComponent>();
            int i = 0;
            int len = childList.size();
            while (i < len) {
                child = (UIComponent)childList.get(i);
                if (!child.isTransient()) {
                    TreeStructComponent structChild = this.internalBuildTreeStructureToSave(child);
                    structChildList.add(structChild);
                }
                ++i;
            }
            TreeStructComponent[] childArray = structChildList.toArray(new TreeStructComponent[structChildList.size()]);
            structComp.setChildren(childArray);
        }
        if (!(facetMap = component.getFacets()).isEmpty()) {
            ArrayList<Object[]> structFacetList = new ArrayList<Object[]>();
            Iterator it = facetMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                child = (UIComponent)entry.getValue();
                if (child.isTransient()) continue;
                String facetName = (String)entry.getKey();
                TreeStructComponent structChild = this.internalBuildTreeStructureToSave(child);
                structFacetList.add(new Object[]{facetName, structChild});
            }
            Object[] facetArray = structFacetList.toArray(new Object[structFacetList.size()]);
            structComp.setFacets(facetArray);
        }
        return structComp;
    }

    public UIViewRoot restoreTreeStructure(Object treeStructRoot) {
        if (treeStructRoot instanceof TreeStructComponent) {
            return (UIViewRoot)this.internalRestoreTreeStructure((TreeStructComponent)treeStructRoot);
        }
        throw new IllegalArgumentException("TreeStructure of type " + treeStructRoot.getClass().getName() + " is not supported.");
    }

    private UIComponent internalRestoreTreeStructure(TreeStructComponent treeStructComp) {
        Object[] facetArray;
        String compClass = treeStructComp.getComponentClass();
        String compId = treeStructComp.getComponentId();
        UIComponent component = (UIComponent)ClassUtils.newInstance(compClass);
        component.setId(compId);
        TreeStructComponent[] childArray = treeStructComp.getChildren();
        if (childArray != null) {
            List childList = component.getChildren();
            int i = 0;
            int len = childArray.length;
            while (i < len) {
                UIComponent child = this.internalRestoreTreeStructure(childArray[i]);
                childList.add(child);
                ++i;
            }
        }
        if ((facetArray = treeStructComp.getFacets()) != null) {
            Map facetMap = component.getFacets();
            int i = 0;
            int len = facetArray.length;
            while (i < len) {
                Object[] tuple = (Object[])facetArray[i];
                String facetName = (String)tuple[0];
                TreeStructComponent structChild = (TreeStructComponent)tuple[1];
                UIComponent child = this.internalRestoreTreeStructure(structChild);
                facetMap.put(facetName, child);
                ++i;
            }
        }
        return component;
    }

    public static class TreeStructComponent
    implements Serializable {
        private String _componentClass;
        private String _componentId;
        private TreeStructComponent[] _children = null;
        private Object[] _facets = null;

        TreeStructComponent(String componentClass, String componentId) {
            this._componentClass = componentClass;
            this._componentId = componentId;
        }

        public String getComponentClass() {
            return this._componentClass;
        }

        public String getComponentId() {
            return this._componentId;
        }

        void setChildren(TreeStructComponent[] children) {
            this._children = children;
        }

        TreeStructComponent[] getChildren() {
            return this._children;
        }

        Object[] getFacets() {
            return this._facets;
        }

        void setFacets(Object[] facets) {
            this._facets = facets;
        }
    }
}

