/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.render.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.jsf.component.html.HtmlLink;

public class HtmlLinkRenderer
extends Renderer {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String media;
        String type;
        ExternalContext extContext;
        String contextPath;
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("link", component);
        HtmlLink link = (HtmlLink)component;
        String href = link.getHref();
        if (href == null) {
            throw new EmptyRuntimeException("href");
        }
        if (!href.startsWith("/")) {
            href = "/" + href;
        }
        if (!"/".equals(contextPath = (extContext = context.getExternalContext()).getRequestContextPath())) {
            href = String.valueOf(contextPath) + href;
        }
        writer.writeAttribute("href", (Object)href, null);
        String rel = link.getRel();
        if (rel != null) {
            writer.writeAttribute("rel", (Object)rel, null);
        }
        if ((type = link.getType()) != null) {
            writer.writeAttribute("type", (Object)type, null);
        }
        if ((media = link.getMedia()) != null) {
            writer.writeAttribute("media", (Object)media, null);
        }
        writer.endElement("link");
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }
}

