/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.util;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Iterator;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.el.ValueBinding;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.Renderer;
import org.seasar.framework.log.Logger;
import org.seasar.framework.util.BooleanConversionUtil;
import org.seasar.framework.util.DoubleConversionUtil;
import org.seasar.framework.util.FloatConversionUtil;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.framework.util.LongConversionUtil;
import org.seasar.framework.util.ShortConversionUtil;
import org.seasar.jsf.util.MessageUtil;
import org.seasar.jsf.util.UIComponentUtil;

public final class RenderUtil {
    private static Logger logger;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.seasar.jsf.util.RenderUtil");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    private RenderUtil() {
    }

    public static void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        Iterator i = component.getChildren().iterator();
        while (i.hasNext()) {
            RenderUtil.encodeChild(context, (UIComponent)i.next());
            if (context.getResponseComplete()) break;
        }
    }

    public static void encodeChild(FacesContext context, UIComponent component) throws IOException {
        component.encodeBegin(context);
        if (component.getRendersChildren()) {
            component.encodeChildren(context);
        } else {
            RenderUtil.encodeChildren(context, component);
        }
        component.encodeEnd(context);
    }

    public static boolean renderAttributes(ResponseWriter writer, UIComponent component, String[] attributeNames) throws IOException {
        boolean somethingDone = false;
        int i = 0;
        int len = attributeNames.length;
        while (i < len) {
            String attrName = attributeNames[i];
            if (RenderUtil.renderAttribute(writer, component, attrName)) {
                somethingDone = true;
            }
            ++i;
        }
        return somethingDone;
    }

    public static boolean renderAttribute(ResponseWriter writer, UIComponent component, String attributeName) throws IOException {
        Object value = component.getAttributes().get(attributeName);
        return RenderUtil.renderAttribute(writer, attributeName, value, attributeName);
    }

    public static boolean renderAttribute(ResponseWriter writer, String attributeName, Object value, String propertyName) throws IOException {
        if (value == null) {
            return false;
        }
        if (attributeName.equalsIgnoreCase("styleClass")) {
            attributeName = "class";
        }
        writer.writeAttribute(attributeName, value, propertyName);
        return true;
    }

    public static void renderIdIfNecessary(ResponseWriter writer, UIComponent component, FacesContext context) throws IOException {
        String id = component.getId();
        if (id != null && !id.startsWith("_id")) {
            writer.writeAttribute("id", (Object)component.getClientId(context), null);
        }
    }

    public static Object getConvertedUIOutputValue(FacesContext context, UIOutput output, Object submittedValue) throws ConverterException {
        if (submittedValue == null) {
            return null;
        }
        Converter converter = RenderUtil.findConverterForSubmittedValue(context, output);
        if (converter == null) {
            return submittedValue;
        }
        return converter.getAsObject(context, (UIComponent)output, (String)submittedValue);
    }

    public static Object getConvertedUIOutputValues(FacesContext context, UIOutput output, Object submittedValue) throws ConverterException {
        if (submittedValue == null) {
            return null;
        }
        Converter converter = RenderUtil.findConverterForSubmittedValue(context, output);
        if (converter == null) {
            return submittedValue;
        }
        int length = Array.getLength(submittedValue);
        Class valueType = RenderUtil.getValueType(context, output);
        Object ret = Array.newInstance(valueType, length);
        int i = 0;
        while (i < length) {
            Object o = converter.getAsObject(context, (UIComponent)output, (String)Array.get(submittedValue, i));
            RenderUtil.setArrayValue(ret, valueType, o, i);
            ++i;
        }
        return ret;
    }

    protected static void setArrayValue(Object array, Class valueType, Object value, int index) {
        if (value == null) {
            return;
        }
        if (valueType == Integer.TYPE) {
            Array.setInt(array, index, IntegerConversionUtil.toPrimitiveInt((Object)value));
        } else if (valueType == Double.TYPE) {
            Array.setDouble(array, index, DoubleConversionUtil.toPrimitiveDouble((Object)value));
        } else if (valueType == Long.TYPE) {
            Array.setLong(array, index, LongConversionUtil.toPrimitiveLong((Object)value));
        } else if (valueType == Float.TYPE) {
            Array.setFloat(array, index, FloatConversionUtil.toPrimitiveFloat((Object)value));
        } else if (valueType == Short.TYPE) {
            Array.setShort(array, index, ShortConversionUtil.toPrimitiveShort((Object)value));
        } else if (valueType == Boolean.TYPE) {
            Array.setBoolean(array, index, BooleanConversionUtil.toPrimitiveBoolean((Object)value));
        } else if (valueType == Character.TYPE) {
            Array.setChar(array, index, ((Character)value).charValue());
        }
        Array.set(array, index, value);
    }

    public static Converter findConverterForSubmittedValue(FacesContext context, UIOutput component) {
        Class valueType;
        block16: {
            block15: {
                Converter converter = component.getConverter();
                if (converter != null) {
                    return converter;
                }
                valueType = RenderUtil.getValueType(context, component);
                if (valueType == null) {
                    return null;
                }
                Class<?> clazz = class$8;
                if (clazz == null) {
                    try {
                        clazz = class$8 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(valueType)) break block15;
                Class<?> clazz2 = class$9;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$9 = Class.forName("java.lang.Object");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz2.equals(valueType)) break block16;
            }
            return null;
        }
        try {
            return context.getApplication().createConverter(valueType);
        }
        catch (FacesException ex) {
            logger.log((Throwable)ex);
            return null;
        }
    }

    public static Class getValueType(FacesContext context, UIOutput component) {
        ValueBinding vb = component.getValueBinding("value");
        if (vb == null) {
            return null;
        }
        Class valueType = vb.getType(context);
        if (valueType == null) {
            return null;
        }
        if (valueType.isArray()) {
            return valueType.getComponentType();
        }
        return valueType;
    }

    public static Renderer getRenderer(FacesContext context, UIComponent component) {
        String rendererType = component.getRendererType();
        if (rendererType == null) {
            return null;
        }
        String renderKitId = context.getViewRoot().getRenderKitId();
        RenderKitFactory rkf = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = rkf.getRenderKit(context, renderKitId);
        return renderKit.getRenderer(component.getFamily(), rendererType);
    }

    public static Object getConvertedValue(FacesContext context, UIInput component, Object submittedValue) {
        try {
            Renderer renderer = RenderUtil.getRenderer(context, (UIComponent)component);
            if (renderer != null) {
                return renderer.getConvertedValue(context, (UIComponent)component, submittedValue);
            }
            if (submittedValue instanceof String) {
                return RenderUtil.getConvertedUIOutputValue(context, (UIOutput)component, submittedValue);
            }
        }
        catch (ConverterException e) {
            FacesMessage facesMessage = e.getFacesMessage();
            if (facesMessage != null) {
                context.addMessage(component.getClientId(context), facesMessage);
            } else {
                context.addMessage(component.getClientId(context), MessageUtil.getErrorMessage("javax.faces.component.UIInput.CONVERSION", new Object[]{UIComponentUtil.getLabel((UIComponent)component)}));
            }
            component.setValid(false);
        }
        return submittedValue;
    }
}

