package org.seasar.jsf.lifecycle;

import javax.faces.FacesException;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.lifecycle.LifecycleFactory;

import org.seasar.jsf.exception.LifecycleIdAlreadyExistRuntimeException;
import org.seasar.jsf.exception.LifecycleIdNotFoundRuntimeException;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LifecycleFactoryImpl extends LifecycleFactory {

	private Map lifecycles = Collections.synchronizedMap(new HashMap());

	public LifecycleFactoryImpl() {
		addLifecycle(LifecycleFactory.DEFAULT_LIFECYCLE, new LifecycleImpl());
	}

	public void addLifecycle(String id, Lifecycle lifecycle) {
		if (lifecycles.put(id, lifecycle) != null) {
			throw new LifecycleIdAlreadyExistRuntimeException(id);
		}
	}

	public Lifecycle getLifecycle(String id) throws FacesException {
		Lifecycle lifecycle = (Lifecycle) lifecycles.get(id);
		if (lifecycle == null) {
			throw new LifecycleIdNotFoundRuntimeException(id);
		}
		return lifecycle;
	}

	public Iterator getLifecycleIds() {
		return lifecycles.keySet().iterator();
	}
}