package org.seasar.jsf.runtime;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.jsp.tagext.Tag;

import org.seasar.jsf.TagPool;

/**
 * @author higa
 *
 */
public class TagPoolImpl implements TagPool {

	private Map tagPoolEntries = new HashMap();
	
	public TagPoolImpl() {
	}

	/**
	 * @see org.seasar.maya.pages.TagPool#request(java.lang.Class)
	 */
	public synchronized Tag request(Class tagClass) {
		TagPoolEntry entry = (TagPoolEntry) tagPoolEntries.get(tagClass.getName());
		if (entry == null) {
			entry = new TagPoolEntry(tagClass);
			tagPoolEntries.put(tagClass.getName(), entry);
		}
		return entry.request();
	}

	/**
	 * @see org.seasar.maya.pages.TagPool#release(javax.servlet.jsp.tagext.Tag)
	 */
	public synchronized void release(Tag tag) {
		TagPoolEntry entry = (TagPoolEntry) tagPoolEntries.get(tag.getClass().getName());
		if (entry != null) {
			entry.release(tag);
		} else {
			throw new IllegalStateException(tag.toString());
		}

	}

}
