package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConfig;
import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagSelector;

/**
 * @author higa
 *
 */
public abstract class AbstractTagSelector implements TagSelector {

	private JsfConfig jsfConfig;

	public void setJsfConfig(JsfConfig jsfConfig) {
		this.jsfConfig = jsfConfig;
	}
	
	protected String getTaglibPrefix(String uri) {
		return jsfConfig.getTaglibPrefix(uri);
	}
	
	protected String getJsfHtmlPrefix() {
		return getTaglibPrefix(JsfConstants.JSF_HTML_URI);
	}
	
	protected String getJsfCorePrefix() {
		return getTaglibPrefix(JsfConstants.JSF_CORE_URI);
	}
	
	protected String getS2JsfPrefix() {
		return getTaglibPrefix(JsfConstants.S2JSF_URI);
	}
	
	protected String getJsfHtmlInject(String tagName) {
		return getJsfHtmlPrefix() + ":" + tagName;
	}
	
	protected String getJsfCoreInject(String tagName) {
		return getJsfCorePrefix() + ":" + tagName;
	}
	
	protected String getS2JsfInject(String tagName) {
		return getS2JsfPrefix() + ":" + tagName;
	}
}