package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.processor.OutputLinkProcessor;
import org.xml.sax.Attributes;

/**
 * @author higa
 *
 */
public class OutputLinkSelector extends AbstractTagSelector {

	private static final String TAG_NAME = "outputLink";
	
	public OutputLinkSelector() {
	}
	
	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.ANCHOR_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		return attributes.getValue(JsfConstants.MAYA_NSURI,
				JsfConstants.ACTION_ATTR) == null;
	}


	public TagProcessor createProcessor() {
		return new OutputLinkProcessor(getInject());
	}

	public String getInject() {
		return getJsfHtmlInject(TAG_NAME);
	}
}
