package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.processor.TitleProcessor;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class TitleSelector extends AbstractTagSelector {

	private static final String TAG_NAME = "title";
	
	public TitleSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.TITLE_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		return attributes.getValue(JsfConstants.MAYA_NSURI,
				JsfConstants.INJECT_ATTR) == null
				&& attributes.getValue(JsfConstants.MAYA_NSURI,
						JsfConstants.VALUE_ATTR) != null;
	}

	public TagProcessor createProcessor() {
		return new TitleProcessor(getInject());
	}
	
	public String getInject() {
		return getS2JsfInject(TAG_NAME);
	}
}