package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.processor.ValidatorProcessor;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class ValidatorSelector extends AbstractTagSelector {

	private static final String TAG_NAME = "validator";
	
	public ValidatorSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		String inject = attributes.getValue(JsfConstants.MAYA_NSURI, JsfConstants.INJECT_ATTR);
		if (inject == null) {
			return false;
		}
		return getInject().equalsIgnoreCase(inject);
	}

	public TagProcessor createProcessor() {
		return new ValidatorProcessor(getInject());
	}
	
	public String getInject() {
		return getS2JsfInject(TAG_NAME);
	}
}