package org.seasar.jsf.taglib;

import javax.faces.component.UIComponent;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.component.ForEach;

/**
 * @author higa
 *  
 */
public class ForEachTag extends UIComponentTagBase {

	private String items;
	
	private String var;
	
	private String varIndex;

	public ForEachTag() {
	}

	public String getItems() {
		return items;
	}

	public void setItems(String items) {
		this.items = items;
	}
	
	public String getVar() {
		return var;
	}

	public void setVar(String var) {
		this.var = var;
	}
	
	public String getVarIndex() {
		return varIndex;
	}

	public void setVarIndex(String varIndex) {
		this.varIndex = varIndex;
	}

	public String getComponentType() {
		return ForEach.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return null;
	}

	/**
	 * @see javax.faces.webapp.UIComponentTag#setProperties(javax.faces.component.UIComponent)
	 */
	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		setComponentProperty(component, JsfConstants.ITEMS_ATTR, items);
		ForEach forEach = (ForEach) component;
		forEach.setVar(var);
		forEach.setVarIndex(varIndex);
	}

	/**
	 * @see javax.servlet.jsp.tagext.Tag#release()
	 */
	public void release() {
		super.release();
		items = null;
		var = null;
		varIndex = null;
	}
}