package org.seasar.jsf.taglib.html;

import javax.faces.component.UIComponent;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;

import org.seasar.jsf.JsfConstants;

public class HtmlSelectBooleanCheckboxTag extends HtmlInputTagBase {

    private String checked;

    public String getComponentType() {
        return HtmlSelectBooleanCheckbox.COMPONENT_TYPE;
    }

    public String getRendererType() {
        return "javax.faces.Checkbox";
    }

    public void setChecked(String checked) {
        this.checked = checked;
    }

    protected void setProperties(UIComponent component) {
        super.setProperties(component);
        setComponentProperty(component, JsfConstants.CHECKED_ATTR, checked);
    }
}