package org.seasar.jsf.util;

import java.util.Map;

import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;

import org.seasar.jsf.exception.NoEditableValueHolderRuntimeException;

/**
 * @author higa
 *  
 */
public final class DecodeUtil {

	private DecodeUtil() {
	}

	public static void decode(FacesContext context, UIComponent component) {
		if (!(component instanceof EditableValueHolder)) {
			throw new NoEditableValueHolderRuntimeException(component
					.getClass());
		}
		Map paramMap = context.getExternalContext().getRequestParameterMap();
		String clientId = component.getClientId(context);
		if (paramMap.containsKey(clientId)) {
			Object submittedValue = paramMap.get(clientId);
			((EditableValueHolder) component).setSubmittedValue(submittedValue);
		}
	}
    
    public static void decodeMany(FacesContext context, UIComponent component) {
        if (!(component instanceof EditableValueHolder)) {
            throw new NoEditableValueHolderRuntimeException(component
                    .getClass());
        }
        Map paramMap = context.getExternalContext().getRequestParameterValuesMap();
        String clientId = component.getClientId(context);
        if (paramMap.containsKey(clientId)) {
            Object submittedValue = paramMap.get(clientId);
            ((EditableValueHolder) component).setSubmittedValue(submittedValue);
        }
    }
}