package org.seasar.jsf.util;

import java.util.List;

import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.servlet.http.HttpServletRequest;

/**
 * @author higa
 *  
 */
public class UIParameterUtil {

	private UIParameterUtil() {
	}
	
	public static void saveParamsToRequest(UICommand command, HttpServletRequest request) {
		List children = command.getChildren();
		for (int i = 0; i < children.size(); ++i) {
			UIComponent child = (UIComponent) children.get(i);
			if (child instanceof UIParameter) {
				UIParameter param = (UIParameter) child;
				request.setAttribute(param.getName(), param.getValue());
			}
		}
	}
}