<?php
	/*
	MGB 0.7.x - OpenSource PHP and MySql Guestbook
	Copyright (C) 2004 - 2013 Juergen Grueneisl - http://www.m-gb.org/

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	=========================
	settings_gravatar.inc.php
	=========================

	DATE OF CREATION: 24.02.2013; 15:09
	*/

	// make sure nobody has direct acces to this script
	if (!defined('ADMINISTRATION')) {
		include ("error.html");
		die();
	} else {
		require ("../includes/functions.inc.php");
		// load template
		$content_settings_gravatar = mgb_load_template("admin", "default", "settings_gravatar", $settings['debug_mode']);

		if(!isset($_GET['action'])) { $_GET['action'] = "settings_gravatar"; }
		if(check_rights($_GET['action'], $_SESSION['ID'])) {
			if(isset($_POST['sent_settings']) AND $_POST['sent_settings'] == 1) {
				// needed values in this script:
				// =============================
				// gravatar_size
				$empty_needed_value = 0;
				if(empty($_POST['gravatar_size'])) { $empty_needed_value = 14; } // no smileys_break information
				if($empty_needed_value == 0) { // no error, continue with saving settings
					// everything's okay now, let's save the data
					$sql = "UPDATE `".$db['prefix']."settings` SET
						`gravatar_show` = '".cleanstr($_POST['gravatar_show'])."',
						`gravatar_rating` = '".cleanstr($_POST['gravatar_rating'])."',
						`gravatar_type` = '".cleanstr($_POST['gravatar_type'])."',
						`gravatar_size` = '".cleanstr($_POST['gravatar_size'])."',
						`gravatar_position` = '".cleanstr($_POST['gravatar_position'])."'";

					if (mgb_sql_connect($sql, "Error while saving gravatar settings.", 0)) {
						$saved_settings_successfull = 1;
						mgb_erase_cache("../cache/");
					}

					require ("../includes/load_settings.inc.php");
				}
			}

			// load active language
			include ("../language/".$settings['language_path']."/settings.php");

			// load template
			$page_include = $content_settings_gravatar;

			// start replacement for template

			// replacement that has nothing to do with front end
			$page_include = template("URL_SETTINGS", "admin.php?action=settings_gravatar".$sid, $page_include);

			// value replacement
			if ($settings['gravatar_show'] == 0) { $selected_gravatar_show_0 = " selected"; } else { $selected_gravatar_show_1 = " selected"; }
			if ($settings['gravatar_rating'] == 0) { $selected_gravatar_rating_0 = " selected"; }
			if ($settings['gravatar_rating'] == 1) { $selected_gravatar_rating_1 = " selected"; }
			if ($settings['gravatar_rating'] == 2) { $selected_gravatar_rating_2 = " selected"; }
			if ($settings['gravatar_rating'] == 3) { $selected_gravatar_rating_3 = " selected"; }
			if ($settings['gravatar_type'] == 0) {
				$selected_gravatar_type_0 = " selected"; }
			elseif ($settings['gravatar_type'] == 1) {
				$selected_gravatar_type_1 = " selected"; }
			elseif ($settings['gravatar_type'] == 2) {
				$selected_gravatar_type_2 = " selected"; }
			elseif ($settings['gravatar_type'] == 3) {
				$selected_gravatar_type_3 = " selected"; }
			elseif ($settings['gravatar_type'] == 4) {
				$selected_gravatar_type_4 = " selected"; }
			elseif ($settings['gravatar_type'] == 5) {
				$selected_gravatar_type_5 = " selected"; }
			elseif ($settings['gravatar_type'] == 6) {
				$selected_gravatar_type_6 = " selected"; }
			if ($settings['gravatar_position'] == 0) { $selected_gravatar_position_0 = " selected"; } else { $selected_gravatar_position_1 = " selected"; }
			$page_include = template("SELECTED_GRAVATAR_SHOW_0", $selected_gravatar_show_0, $page_include);
			$page_include = template("SELECTED_GRAVATAR_SHOW_1", $selected_gravatar_show_1, $page_include);
			$page_include = template("SELECTED_GRAVATAR_RATING_0", $selected_gravatar_rating_0, $page_include);
			$page_include = template("SELECTED_GRAVATAR_RATING_1", $selected_gravatar_rating_1, $page_include);
			$page_include = template("SELECTED_GRAVATAR_RATING_2", $selected_gravatar_rating_2, $page_include);
			$page_include = template("SELECTED_GRAVATAR_RATING_3", $selected_gravatar_rating_3, $page_include);
			$page_include = template("SELECTED_GRAVATAR_TYPE_0", $selected_gravatar_type_0, $page_include);
			$page_include = template("SELECTED_GRAVATAR_TYPE_1", $selected_gravatar_type_1, $page_include);
			$page_include = template("SELECTED_GRAVATAR_TYPE_2", $selected_gravatar_type_2, $page_include);
			$page_include = template("SELECTED_GRAVATAR_TYPE_3", $selected_gravatar_type_3, $page_include);
			$page_include = template("SELECTED_GRAVATAR_TYPE_4", $selected_gravatar_type_4, $page_include);
			$page_include = template("SELECTED_GRAVATAR_TYPE_5", $selected_gravatar_type_5, $page_include);
			$page_include = template("SELECTED_GRAVATAR_TYPE_6", $selected_gravatar_type_6, $page_include);
			$page_include = template("SELECTED_GRAVATAR_POSITION_0", $selected_gravatar_position_0, $page_include);
			$page_include = template("SELECTED_GRAVATAR_POSITION_1", $selected_gravatar_position_1, $page_include);
			$page_include = template("EDIT_GRAVATAR_SIZE", $settings['gravatar_size'], $page_include);

			// is scrolling function needed?
			$content_scrolling_function = "";
		} else {
			$page_include = "<span class=\"admin\">".$lang['errormessage'][4]."</span>"; // user has no access to this page, user level too low
			$content_scrolling_function = "<br>";
		}
	}
?>
