/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.action.ICreateFriendshipAction;
import jp.sourceforge.shovel.action.impl.CreateFriendshipActionImpl;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IFriendshipForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class CreateFriendshipActionImpl
implements ICreateFriendshipAction {
    HttpServletRequest request_;
    IFriendshipForm actionForm_;

    public String perform() throws Exception {
        IFriendship friend;
        FormatType formatType = this.actionForm_.getFormatType();
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        long userId = this.actionForm_.getUserId();
        String foreignKey = this.actionForm_.getForeignKey();
        if (foreignKey == null || foreignKey.length() <= 0) {
            IUser user = directoryService.getLoginUser();
            friend = shovelService.createFriendship(user.getUserId());
        } else if (foreignKey.matches("^[0-9]+$")) {
            foreignKey = null;
            friend = shovelService.createFriendship(userId);
        } else {
            userId = 0L;
            friend = shovelService.createFriendship(foreignKey);
        }
        String forward = null;
        switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
            case 1: 
            case 2: {
                shovelService.prepareForView(new IFriendship[]{friend}, 1, false);
                this.request_.setAttribute("friendship", (Object)friend);
                this.request_.setAttribute("friends", (Object)true);
                IStatus status = null;
                status = userId > 0L ? shovelService.getRecent(userId) : shovelService.getRecent(foreignKey);
                if (status != null) {
                    shovelService.prepareForView(status);
                    HashMap<String, IStatus> statusMap = new HashMap<String, IStatus>();
                    statusMap.put(String.valueOf(friend.getPassiveId()), status);
                    this.request_.setAttribute("statuses", statusMap);
                }
                forward = formatType.getId();
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        return forward;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setFriendshipForm(IFriendshipForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }
}

