/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.action.IDestroyAccountsAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.IAccountsForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;

public class DestroyAccountsActionImpl
implements IDestroyAccountsAction {
    IAccountsForm actionForm_;
    HttpServletRequest request_;
    HttpSession session_;

    @Perform(CSRF=true, administrator=true)
    public String perform() throws Exception {
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        long[] userIds = this.actionForm_.getUserIds();
        if (userIds != null && userIds.length > 0) {
            directoryService.removeUsers(userIds);
        } else {
            directoryService.removeUser(this.actionForm_.getUserId());
        }
        IListRefine listRefine = (IListRefine)this.session_.getAttribute("listRefine");
        SortOrderType sortOrderType = listRefine.getSortOrderType();
        IUser[] users = directoryService.getUsers(SortType.USER_ID, sortOrderType, 0);
        if (users != null && users.length > 0) {
            IUser[] tmp = shovelService.prepareForView(users, 0);
            this.request_.setAttribute("nextPage", (Object)(tmp.length > users.length ? 1 : 0));
            users = tmp;
        }
        this.request_.setAttribute("users", (Object)users);
        return "success";
    }

    public void setAccountsForm(IAccountsForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setSession(HttpSession session) {
        this.session_ = session;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }
}

