/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.IFollowersAction;
import jp.sourceforge.shovel.action.impl.FollowersActionImpl;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IFriendshipForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.seasar.framework.container.S2Container;

public class FollowersActionImpl
implements IFollowersAction {
    IFriendshipForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;
    HttpSession session_;

    @Perform(CSRF=false, login=true)
    public String perform() throws Exception {
        FormatType formatType = this.actionForm_.getFormatType();
        int page = this.actionForm_.getPage();
        int limit = this.actionForm_.getCount();
        String foreignKey = this.actionForm_.getForeignKey();
        long userId = this.actionForm_.getUserId();
        if (formatType.isHtml()) {
            IListRefine listRefine = (IListRefine)this.session_.getAttribute("listRefine");
            if (listRefine == null || !listRefine.getViewType().isFollowers()) {
                listRefine = (IListRefine)this.container_.getComponent(IListRefine.class);
                this.session_.setAttribute("listRefine", (Object)listRefine);
            } else if (this.actionForm_.getMethodType().isPage()) {
                listRefine.setPage(this.actionForm_.getPage());
            }
            listRefine.setViewType(ViewType.FOLLOWERS);
            page = listRefine.getPage();
            limit = 0;
        }
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser user = null;
        if (foreignKey == null || foreignKey.length() <= 0) {
            user = directoryService.getLoginUser();
            foreignKey = user.getForeignKey();
        } else {
            user = foreignKey.matches("^[0-9]+$") ? directoryService.getUser(userId) : directoryService.getUser(foreignKey);
        }
        shovelService.prepareForView(user);
        this.request_.setAttribute("user", (Object)user);
        IFriendship[] temp = shovelService.getFollowers(foreignKey, true, page, limit);
        IFriendship[] followers = shovelService.prepareForView(temp, limit, true);
        this.request_.setAttribute("friendships", (Object)followers);
        String forward = null;
        switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
            case 1: {
                if (followers != null && followers.length > 0) {
                    this.request_.setAttribute("nextPage", (Object)(temp.length > followers.length ? 1 : 0));
                }
                forward = this.actionForm_.isPartial() ? "partial" : "full";
                break;
            }
            case 2: 
            case 3: {
                IStatus[] statuses;
                if (followers != null && followers.length > 0) {
                    long[] userIds = new long[followers.length];
                    int i = 0;
                    for (IFriendship follower : followers) {
                        userIds[i++] = follower.getActiveId();
                    }
                    statuses = shovelService.getRecents(userIds);
                    shovelService.prepareForView(statuses, 0, true);
                } else {
                    statuses = new IStatus[]{};
                }
                HashMap<String, IStatus> statusMap = new HashMap<String, IStatus>();
                for (IStatus status : statuses) {
                    long senderId = status.getSenderId();
                    statusMap.put(String.valueOf(senderId), status);
                }
                this.request_.setAttribute("statuses", statusMap);
                forward = formatType.getId();
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        return forward;
    }

    public void setFriendshipForm(IFriendshipForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setSession(HttpSession session) {
        this.session_ = session;
    }
}

