/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.MethodType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.IFriendRequestsAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.IFriendshipForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.seasar.framework.container.S2Container;

public class FriendRequestsActionImpl
implements IFriendRequestsAction {
    IFriendshipForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;
    HttpSession session_;

    @Perform(CSRF=false, login=true)
    public String perform() throws Exception {
        int page = this.actionForm_.getPage();
        IListRefine listRefine = (IListRefine)this.session_.getAttribute("listRefine");
        if (listRefine == null || !listRefine.getViewType().isFriendRequests()) {
            listRefine = (IListRefine)this.container_.getComponent(IListRefine.class);
            this.session_.setAttribute("listRefine", (Object)listRefine);
        } else if (this.actionForm_.getMethodType() == MethodType.PAGE) {
            listRefine.setPage(this.actionForm_.getPage());
        }
        listRefine.setViewType(ViewType.FRIEND_REQUESTS);
        page = listRefine.getPage();
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        String foreignKey = this.actionForm_.getForeignKey();
        long userId = this.actionForm_.getUserId();
        if (foreignKey == null || foreignKey.length() <= 0) {
            IUser user = directoryService.getLoginUser();
            foreignKey = user.getForeignKey();
        } else if (foreignKey.matches("^[0-9]+$")) {
            IUser user = directoryService.getUser(userId);
        } else {
            IUser user = directoryService.getUser(foreignKey);
        }
        IFriendship[] tmp = shovelService.getRequests(foreignKey, page, 0);
        IFriendship[] friends = shovelService.prepareForView(tmp, 0, true);
        this.request_.setAttribute("friendships", (Object)friends);
        if (friends != null && friends.length > 0) {
            this.request_.setAttribute("nextPage", (Object)(tmp.length > friends.length ? 1 : 0));
        }
        return this.actionForm_.isPartial() ? "partial" : "full";
    }

    public void setFriendshipForm(IFriendshipForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setSession(HttpSession session) {
        this.session_ = session;
    }
}

