/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.IFriendsTimelineAction;
import jp.sourceforge.shovel.action.impl.FriendsTimelineActionImpl;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.apache.commons.lang.ArrayUtils;
import org.seasar.framework.container.S2Container;

public class FriendsTimelineActionImpl
implements IFriendsTimelineAction {
    IStatusesForm actionForm_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    S2Container container_;
    HttpSession session_;

    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        FormatType formatType = this.actionForm_.getFormatType();
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        String foreignKey = this.actionForm_.getForeignKey();
        long userId = this.actionForm_.getUserId();
        IUser user = null;
        boolean home = false;
        if (foreignKey == null || foreignKey.length() <= 0) {
            user = directoryService.getLoginUser();
            home = true;
        } else {
            user = foreignKey.matches("^[0-9]+$") ? directoryService.getUser(userId) : directoryService.getUser(foreignKey);
        }
        if (!home && user.isProtect()) {
            IUser login = directoryService.getLoginUser();
            boolean protect = true;
            if (login != null) {
                if (login.getUserId() == user.getUserId()) {
                    protect = false;
                } else {
                    IFriendship[] friends;
                    for (IFriendship tmp : friends = shovelService.getRequests(user.getUserId())) {
                        if (tmp.getRemovedTime() > 0L) continue;
                        if (tmp.getPassiveId() == user.getUserId()) {
                            protect &= !tmp.isAccept();
                            this.request_.setAttribute("friend", (Object)tmp);
                            continue;
                        }
                        protect &= false;
                        this.request_.setAttribute("follower", (Object)tmp);
                    }
                }
            }
            if (protect) {
                this.request_.setAttribute("protect", (Object)true);
                this.request_.setAttribute("viewType", (Object)ViewType.FRIENDS_TIMELINE);
                String forward = null;
                switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
                    case 1: {
                        shovelService.prepareForView(user);
                        this.request_.setAttribute("user", (Object)user);
                        IFriendship[] friendships = shovelService.getFriends(user.getForeignKey(), 0, 100);
                        this.request_.setAttribute("viewAllFriends", (Object)(friendships.length > 100 ? 1 : 0));
                        friendships = shovelService.prepareForView(friendships, 100, true);
                        this.request_.setAttribute("friendships", (Object)friendships);
                        forward = this.actionForm_.isPartial() ? "people_partial" : "people_full";
                        break;
                    }
                    case 2: 
                    case 3: {
                        forward = formatType.getId();
                        break;
                    }
                    case 4: 
                    case 5: {
                        IStatus[] statuses = new IStatus[]{};
                        shovelService.outputFeed(formatType, ViewType.FRIENDS_TIMELINE, user, statuses);
                        break;
                    }
                    default: {
                        throw new ApplicationException("");
                    }
                }
                return forward;
            }
        }
        int page = this.actionForm_.getPage();
        String since = this.actionForm_.getSince();
        int limit = this.actionForm_.getCount();
        IListRefine listRefine = null;
        Object[] statuses = null;
        Object[] temp = null;
        IStatus status = null;
        if (formatType.isHtml()) {
            listRefine = (IListRefine)this.session_.getAttribute("listRefine");
            if (listRefine == null || !listRefine.getViewType().isRecent() && !listRefine.getViewType().isWithFriends() || listRefine.getViewType().isRecent() && foreignKey != null && foreignKey.length() > 0 || listRefine.getViewType().isWithFriends() && (foreignKey == null || foreignKey.length() <= 0)) {
                listRefine = (IListRefine)this.container_.getComponent(IListRefine.class);
                this.session_.setAttribute("listRefine", (Object)listRefine);
            } else if (this.actionForm_.getMethodType().isPage()) {
                listRefine.setPage(this.actionForm_.getPage());
            }
            page = listRefine.getPage();
            since = null;
            limit = 0;
            if (home) {
                temp = shovelService.getStatuses(user.getForeignKey(), true, page, limit, 0, 1);
                statuses = shovelService.prepareForView((IStatus[])temp, limit, true);
            } else {
                int correctedLimit = 0;
                if (formatType.isHtml()) {
                    correctedLimit = 2;
                    status = shovelService.getRecent(user.getForeignKey());
                    this.request_.setAttribute("status", (Object)status);
                }
                statuses = shovelService.getStatuses(user.getForeignKey(), true, page, limit, 0, correctedLimit);
                temp = status == null ? statuses : (IStatus[])ArrayUtils.add((Object[])statuses, (Object)status);
                shovelService.prepareForView((IStatus[])temp, limit, false);
            }
        } else {
            if (since == null || since.length() <= 0) {
                since = this.request_.getHeader("If-Modified-Since");
            }
            statuses = since == null || since.length() <= 0 ? shovelService.getStatuses(user.getForeignKey(), true, page, limit, 0, 0) : shovelService.getStatuses(user.getForeignKey(), true, since, limit);
            shovelService.prepareForView((IStatus[])statuses, limit, false);
        }
        String forward = null;
        switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
            case 1: {
                shovelService.prepareForView(user);
                this.request_.setAttribute("user", (Object)user);
                if (home) {
                    listRefine.setViewType(ViewType.RECENT);
                    forward = this.actionForm_.isPartial() ? "home_partial" : "home_full";
                } else {
                    listRefine.setViewType(ViewType.WITH_FRIENDS);
                    IFriendship friend = shovelService.getFriend(user.getForeignKey());
                    this.request_.setAttribute("friend", (Object)(friend != null ? 1 : 0));
                    temp = statuses;
                    if (status != null) {
                        if (temp[0].getStatusId() < status.getStatusId()) {
                            temp = (IStatus[])ArrayUtils.subarray((Object[])temp, (int)1, (int)temp.length);
                        } else if (temp[temp.length - 1].getStatusId() > status.getStatusId()) {
                            temp = (IStatus[])ArrayUtils.subarray((Object[])temp, (int)0, (int)(temp.length - 1));
                        } else {
                            ArrayList<Object> statusList = new ArrayList<Object>();
                            for (Object tmp : temp) {
                                if (tmp.getStatusId() == status.getStatusId()) continue;
                                statusList.add(tmp);
                            }
                            temp = statusList.toArray(new IStatus[statusList.size()]);
                        }
                    }
                    statuses = shovelService.truncate((IStatus[])temp, limit);
                    forward = this.actionForm_.isPartial() ? "people_partial" : "people_full";
                }
                boolean nextPage = false;
                if (statuses != null && statuses.length > 0) {
                    nextPage = temp.length > statuses.length;
                }
                this.request_.setAttribute("nextPage", (Object)nextPage);
                IFriendship[] friendships = shovelService.getFriends(user.getForeignKey(), 0, 100);
                this.request_.setAttribute("viewAllFriends", (Object)(friendships.length > 100 ? 1 : 0));
                friendships = shovelService.prepareForView(friendships, 100, true);
                this.request_.setAttribute("friendships", (Object)friendships);
                break;
            }
            case 2: 
            case 3: {
                forward = formatType.getId();
                break;
            }
            case 4: 
            case 5: {
                shovelService.outputFeed(formatType, ViewType.FRIENDS_TIMELINE, user, (IStatus[])statuses);
                return null;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        this.request_.setAttribute("statuses", (Object)statuses);
        return forward;
    }

    public void setStatusesForm(IStatusesForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response_ = response;
    }

    public void setSession(HttpSession session) {
        this.session_ = session;
    }
}

