/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import au.com.bytecode.opencsv.bean.ColumnPositionMappingStrategy;
import au.com.bytecode.opencsv.bean.CsvToBean;
import au.com.bytecode.opencsv.bean.MappingStrategy;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.action.IImportAccountsAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.entity.impl.UserImpl;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IImportAccountsForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.apache.struts.upload.FormFile;

public class ImportAccountsActionImpl
implements IImportAccountsAction {
    IImportAccountsForm actionForm_;
    HttpServletRequest request_;
    HttpSession session_;
    static final Pattern pattern_ = Pattern.compile("\\s*(\")?(.*)\\1?");

    String trimQuote(String data) {
        Matcher matcher = pattern_.matcher(data);
        if (matcher.find()) {
            data = matcher.group(2);
        }
        return data.trim();
    }

    @Perform(CSRF=true, administrator=true)
    public String perform() throws Exception {
        FormFile file = this.actionForm_.getFile();
        if (file == null) {
            throw new ApplicationException("");
        }
        String charSet = this.actionForm_.getCharSet();
        InputStreamReader reader = new InputStreamReader(file.getInputStream(), charSet);
        ColumnPositionMappingStrategy mapper = new ColumnPositionMappingStrategy();
        mapper.setType(UserImpl.class);
        String[] columns = new String[]{"displayName", "foreignKey", "password", "email", "location"};
        mapper.setColumnMapping(columns);
        CsvToBean csv = new CsvToBean();
        List userList = csv.parse((MappingStrategy)mapper, (Reader)reader);
        HashMap<String, IUser> userMap = new HashMap<String, IUser>();
        String[] foreignKeys = new String[userList.size()];
        int i = 0;
        for (IUser user : userList) {
            user.setDisplayName(this.trimQuote(user.getDisplayName()));
            user.setForeignKey(this.trimQuote(user.getForeignKey()));
            user.setPassword(this.trimQuote(user.getPassword()));
            user.setEmail(this.trimQuote(user.getEmail()));
            user.setLocation(this.trimQuote(user.getLocation()));
            foreignKeys[i++] = user.getForeignKey();
            userMap.put(user.getForeignKey(), user);
        }
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser[] users = directoryService.getUsers(foreignKeys);
        if (users != null && users.length > 0) {
            for (IUser user : users) {
                IUser tmp = (IUser)userMap.get(user.getForeignKey());
                tmp.setUserId(user.getUserId());
            }
        }
        for (IUser user : userList) {
            String displayName = user.getDisplayName();
            String foreignKey = user.getForeignKey();
            String password = user.getPassword();
            String email = user.getEmail();
            String location = user.getLocation();
            if (user.getUserId() > 0L) {
                directoryService.updateUserFromImportCsv(user);
                continue;
            }
            directoryService.createUser(displayName, foreignKey, password, email, null, location, null, "", false, false);
        }
        IListRefine listRefine = (IListRefine)this.session_.getAttribute("listRefine");
        SortOrderType sortOrderType = listRefine.getSortOrderType();
        users = directoryService.getUsers(SortType.USER_ID, sortOrderType, 0);
        if (users != null && users.length > 0) {
            IUser[] tmp = shovelService.prepareForView(users, 0);
            this.request_.setAttribute("nextPage", (Object)(tmp.length > users.length ? 1 : 0));
            users = tmp;
        }
        this.request_.setAttribute("users", (Object)users);
        this.request_.setAttribute("callback", (Object)"window.parent.shovel.controller.onChangeConfig($('#content').html());");
        this.request_.setAttribute("template", (Object)"system/accounts.ftl");
        return "success";
    }

    public void setImportAccountsForm(IImportAccountsForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setSession(HttpSession session) {
        this.session_ = session;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }
}

