/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.IRepliesAction;
import jp.sourceforge.shovel.action.impl.RepliesActionImpl;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.seasar.framework.container.S2Container;

public class RepliesActionImpl
implements IRepliesAction {
    IStatusesForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;
    HttpSession session_;

    @Perform(CSRF=false)
    public String perform() throws Exception {
        FormatType formatType = this.actionForm_.getFormatType();
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser user = directoryService.getLoginUser();
        this.request_.setAttribute("user", (Object)user);
        int page = this.actionForm_.getPage();
        int limit = this.actionForm_.getCount();
        if (formatType.isHtml()) {
            IListRefine listRefine = (IListRefine)this.session_.getAttribute("listRefine");
            if (listRefine == null || !listRefine.getViewType().isReplies()) {
                listRefine = (IListRefine)this.container_.getComponent(IListRefine.class);
                this.session_.setAttribute("listRefine", (Object)listRefine);
            } else if (this.actionForm_.getMethodType().isPage()) {
                listRefine.setPage(this.actionForm_.getPage());
            }
            listRefine.setViewType(ViewType.REPLIES);
            page = listRefine.getPage();
            limit = 0;
        }
        IStatus[] temp = shovelService.getReplies(user.getForeignKey(), page, limit);
        IStatus[] replies = shovelService.prepareForView(temp, limit, true);
        boolean nextPage = false;
        if (replies != null && replies.length > 0) {
            nextPage = temp.length > replies.length;
        }
        this.request_.setAttribute("statuses", (Object)replies);
        this.request_.setAttribute("nextPage", (Object)nextPage);
        String forward = null;
        switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
            case 1: {
                if (user != null) {
                    shovelService.prepareForView(user);
                    this.request_.setAttribute("user", (Object)user);
                    String foreignKey = user.getForeignKey();
                    IFriendship[] friendships = shovelService.getFriends(foreignKey, 0, 100);
                    this.request_.setAttribute("viewAllFriends", (Object)(friendships.length > 100 ? 1 : 0));
                    friendships = shovelService.prepareForView(friendships, 100, true);
                    this.request_.setAttribute("friendships", (Object)friendships);
                }
                forward = this.actionForm_.isPartial() ? "partial" : "full";
                break;
            }
            case 2: 
            case 3: {
                forward = formatType.getId();
                break;
            }
            case 4: 
            case 5: {
                shovelService.outputFeed(formatType, ViewType.REPLIES, user, replies);
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        return forward;
    }

    public void setStatusesForm(IStatusesForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setSession(HttpSession session) {
        this.session_ = session;
    }
}

