/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.IUserTimelineAction;
import jp.sourceforge.shovel.action.impl.UserTimelineActionImpl;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.apache.commons.lang.ArrayUtils;
import org.seasar.framework.container.S2Container;

public class UserTimelineActionImpl
implements IUserTimelineAction {
    IStatusesForm actionForm_;
    HttpServletRequest request_;
    S2Container container_;
    HttpSession session_;

    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        FormatType formatType = this.actionForm_.getFormatType();
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        String foreignKey = this.actionForm_.getForeignKey();
        long userId = this.actionForm_.getUserId();
        IUser user = null;
        user = foreignKey == null || foreignKey.length() <= 0 ? directoryService.getLoginUser() : (foreignKey.matches("^[0-9]+$") ? directoryService.getUser(userId) : directoryService.getUser(foreignKey));
        if (user.isProtect()) {
            IUser login = directoryService.getLoginUser();
            boolean protect = true;
            if (login != null) {
                if (login.getUserId() == user.getUserId()) {
                    protect = false;
                } else {
                    IFriendship[] friends;
                    for (IFriendship tmp : friends = shovelService.getRequests(user.getUserId())) {
                        if (tmp.getRemovedTime() > 0L) continue;
                        if (tmp.getPassiveId() == user.getUserId()) {
                            protect &= !tmp.isAccept();
                            this.request_.setAttribute("friend", (Object)tmp);
                            continue;
                        }
                        protect &= false;
                        this.request_.setAttribute("follower", (Object)tmp);
                    }
                }
            }
            if (protect) {
                this.request_.setAttribute("protect", (Object)true);
                this.request_.setAttribute("viewType", (Object)ViewType.USER_TIMELINE);
                String forward = null;
                switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
                    case 1: {
                        shovelService.prepareForView(user);
                        this.request_.setAttribute("user", (Object)user);
                        IFriendship[] friendships = shovelService.getFriends(user.getForeignKey(), 0, 100);
                        this.request_.setAttribute("viewAllFriends", (Object)(friendships.length > 100 ? 1 : 0));
                        friendships = shovelService.prepareForView(friendships, 100, true);
                        this.request_.setAttribute("friendships", (Object)friendships);
                        forward = this.actionForm_.isPartial() ? "partial" : "full";
                        break;
                    }
                    case 2: 
                    case 3: {
                        forward = formatType.getId();
                        break;
                    }
                    case 4: 
                    case 5: {
                        IStatus[] statuses = new IStatus[]{};
                        shovelService.outputFeed(formatType, ViewType.USER_TIMELINE, user, statuses);
                        break;
                    }
                    default: {
                        throw new ApplicationException("");
                    }
                }
                return forward;
            }
        }
        int page = this.actionForm_.getPage();
        String since = this.actionForm_.getSince();
        int limit = this.actionForm_.getCount();
        int correctedOffset = 0;
        int correctedLimit = 0;
        Object[] statuses = null;
        if (formatType.isHtml()) {
            IListRefine listRefine = (IListRefine)this.session_.getAttribute("listRefine");
            if (listRefine == null || !listRefine.getViewType().isUserTimeline()) {
                listRefine = (IListRefine)this.container_.getComponent(IListRefine.class);
                this.session_.setAttribute("listRefine", (Object)listRefine);
            } else if (this.actionForm_.getMethodType().isPage()) {
                listRefine.setPage(this.actionForm_.getPage());
            }
            listRefine.setViewType(ViewType.USER_TIMELINE);
            page = listRefine.getPage();
            limit = 0;
            if (page > 0) {
                correctedOffset = 1;
            }
            correctedLimit = 2;
            statuses = shovelService.getStatuses(user.getForeignKey(), false, page, limit, correctedOffset, correctedLimit);
        } else {
            if (since == null) {
                since = this.request_.getHeader("If-Modified-Since");
            }
            statuses = since == null ? shovelService.getStatuses(user.getForeignKey(), false, page, limit, 0, 0) : shovelService.getStatuses(user.getForeignKey(), false, since, limit);
        }
        shovelService.prepareForView((IStatus[])statuses, limit, false);
        String forward = null;
        switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
            case 1: {
                Object[] temp = statuses;
                IStatus status = null;
                if (page > 0) {
                    status = shovelService.getRecent(user.getForeignKey());
                    temp = (IStatus[])ArrayUtils.add((Object[])statuses, (Object)status);
                } else if (statuses.length > 0) {
                    status = statuses[0];
                    statuses = (IStatus[])ArrayUtils.subarray((Object[])statuses, (int)1, (int)statuses.length);
                }
                this.request_.setAttribute("status", (Object)status);
                shovelService.prepareForView(user);
                this.request_.setAttribute("user", (Object)user);
                IFriendship[] friendships = shovelService.getFriends(user.getForeignKey(), 0, 100);
                this.request_.setAttribute("viewAllFriends", (Object)(friendships.length > 100 ? 1 : 0));
                friendships = shovelService.prepareForView(friendships, 100, true);
                this.request_.setAttribute("friendships", (Object)friendships);
                IFriendship friend = shovelService.getFriend(user.getForeignKey());
                this.request_.setAttribute("friend", (Object)(friend != null ? 1 : 0));
                temp = statuses;
                statuses = shovelService.truncate((IStatus[])temp, limit);
                this.request_.setAttribute("nextPage", (Object)(temp.length > statuses.length ? 1 : 0));
                forward = this.actionForm_.isPartial() ? "partial" : "full";
                break;
            }
            case 2: 
            case 3: {
                forward = formatType.getId();
                break;
            }
            case 4: 
            case 5: {
                shovelService.outputFeed(formatType, ViewType.USER_TIMELINE, user, (IStatus[])statuses);
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        this.request_.setAttribute("statuses", (Object)statuses);
        return forward;
    }

    public void setStatusesForm(IStatusesForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setSession(HttpSession session) {
        this.session_ = session;
    }
}

