/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.device.impl;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashSet;
import jp.sourceforge.shovel.AvailabilityType;
import jp.sourceforge.shovel.device.IAbstractDeviceWrapper;
import jp.sourceforge.shovel.device.impl.AbstractDeviceWrapperImpl;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IFavorite;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IStatusWrapper;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IDirectoryLogic;
import jp.sourceforge.shovel.logic.IShovelLogic;
import jp.sourceforge.shovel.thread.MessengerMain;
import org.apache.commons.lang.ArrayUtils;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.log.Logger;

public abstract class AbstractDeviceWrapperImpl
implements IAbstractDeviceWrapper {
    static Logger logger = Logger.getLogger(AbstractDeviceWrapperImpl.class);
    String displayName_;
    static final String bodyFormat_ = "{0}: {1}";
    S2Container container_;

    public String getDisplayName() {
        return this.displayName_;
    }

    public void setDisplayName(String displayName) {
        this.displayName_ = displayName;
    }

    boolean isRepeat() {
        return true;
    }

    abstract void sendMessage(IUser var1, String var2) throws ApplicationException;

    void replyMessage(IUser sender, IUser receiver, String body) throws ApplicationException {
        this.sendMessage(sender, body);
        IFriendship follower = this.getShovelLogic().getFriendship(receiver.getUserId(), sender.getUserId());
        if (sender.isProtect() && !follower.isAccept()) {
            return;
        }
        this.sendMessage(receiver, body);
    }

    void receiveMessage(String address, String body) throws ApplicationException {
        IDirectoryLogic directoryLogic = this.getDirectoryLogic();
        IUser user = directoryLogic.getUserByDevice(this.getDeviceType(), address);
        if (user == null) {
            return;
        }
        IDevice device = user.getDevice();
        if (device.getAvailabilityType().isInactivation()) {
            String releaseKey = user.getReleaseKey();
            if (releaseKey.compareTo(body) == 0) {
                device.setAvailabilityType(AvailabilityType.ON);
                this.getShovelLogic().updateDevice(device);
                StringBuilder message = new StringBuilder();
                message.append("\u30a2\u30ab\u30a6\u30f3\u30c8\u3092\u78ba\u8a8d\u3057\u307e\u3057\u305f\u3002\n");
                message.append("\u30c7\u30d0\u30a4\u30b9\u306b\u901a\u77e5\u3092\u958b\u59cb\u3057\u307e\u3059\u3002\n");
                message.append("\u901a\u77e5\u3092\u6b62\u3081\u305f\u3044\u3068\u304d\u306f\"off\"\u3092\u9001\u3063\u3066\u304f\u3060\u3055\u3044\u3002\n");
                message.append("\u8a73\u7d30\u306b\u3064\u3044\u3066\u306f\"help\"\u3092\u9001\u3063\u3066\u304f\u3060\u3055\u3044\u3002");
                this.sendMessage(user, message.toString());
            }
            return;
        }
        IShovelLogic shovelLogic = this.getShovelLogic();
        IStatusWrapper statusWrapper = shovelLogic.parseStatus(body);
        if (device.getAvailabilityType().isOff() && !statusWrapper.getStatusType().isWake()) {
            return;
        }
        String foreignKey = statusWrapper.getForeignKey();
        switch (1.$SwitchMap$jp$sourceforge$shovel$StatusType[statusWrapper.getStatusType().ordinal()]) {
            case 1: {
                directoryLogic.incrementStatus(user.getForeignKey());
                long senderId = user.getUserId();
                boolean open = statusWrapper.isOpen();
                long referenceSenderId = 0L;
                if (foreignKey != null) {
                    user = directoryLogic.getUserByForeignKey(foreignKey);
                    referenceSenderId = user.getUserId();
                }
                shovelLogic.receiveStatus(body, "im", referenceSenderId, open, senderId);
                break;
            }
            case 2: {
                long senderId = user.getUserId();
                user = directoryLogic.getUserByForeignKey(foreignKey);
                long receiverId = user.getUserId();
                String text = statusWrapper.getText();
                directoryLogic.incrementDirectMessages(foreignKey);
                shovelLogic.createDirectMessage(text, "im", senderId, receiverId);
                StringBuilder message = new StringBuilder();
                message.append(foreignKey);
                message.append("\u306b\u30c0\u30a4\u30ec\u30af\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8\u3092\u9001\u308a\u307e\u3057\u305f\u3002");
                this.sendMessage(user, message.toString());
                break;
            }
            case 3: {
                IUser login = user;
                user = directoryLogic.getUserByForeignKey(foreignKey);
                IStatus status = shovelLogic.getRecent(user.getUserId());
                StringBuilder message = new StringBuilder();
                if (status == null) {
                    message.append("\u307e\u3060");
                    message.append(foreignKey);
                    message.append("\u306e\u6295\u7a3f\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
                } else {
                    long statusId = status.getStatusId();
                    IFavorite favorite = shovelLogic.getFavorite(statusId, login.getUserId());
                    if (favorite == null) {
                        directoryLogic.incrementFavorites(login.getForeignKey());
                        if (status.getSenderId() != login.getUserId()) {
                            directoryLogic.incrementGivenFavorites(status.getSenderId());
                        }
                        shovelLogic.incrementGivenFavorites(statusId);
                        shovelLogic.createFavorite(statusId, login.getUserId());
                        message.append("\u300c");
                        message.append(foreignKey);
                        message.append(":");
                        message.append(status.getBody());
                        message.append("\u300d\n");
                        message.append("\u3092\u304a\u6c17\u306b\u5165\u308a\u306b\u767b\u9332\u3057\u307e\u3057\u305f\u3002");
                    } else {
                        message.append("\u304a\u6c17\u306b\u5165\u308a\u306b\u767b\u9332\u305a\u307f\u3067\u3059\u3002");
                    }
                }
                this.sendMessage(user, message.toString());
                break;
            }
            case 4: {
                IUser active = user;
                IUser passive = directoryLogic.getUserByForeignKey(foreignKey);
                IFriendship friend = this.createFriendship(active, passive);
                StringBuilder message = new StringBuilder();
                message.append(foreignKey);
                if (passive.isProtect() && !friend.isAccept()) {
                    message.append("\u306b\u30d5\u30a9\u30ed\u30fc\u306e\u304a\u9858\u3044\u3092\u3057\u307e\u3057\u305f\u3002");
                } else {
                    message.append("\u3092\u30d5\u30a9\u30ed\u30fc\u3057\u307e\u3057\u305f\u3002");
                }
                this.sendMessage(user, message.toString());
                break;
            }
            case 5: {
                IUser active = user;
                IUser passive = directoryLogic.getUserByForeignKey(foreignKey);
                this.destroyFriendship(active, passive);
                StringBuilder message = new StringBuilder();
                message.append(foreignKey);
                message.append("\u306e\u30d5\u30a9\u30ed\u30fc\u3092\u505c\u6b62\u3057\u307e\u3057\u305f\u3002");
                this.sendMessage(user, message.toString());
                break;
            }
            case 6: {
                IUser active = user;
                IUser passive = directoryLogic.getUserByForeignKey(foreignKey);
                this.updateFriendshipNotify(user, passive, true);
                StringBuilder message = new StringBuilder();
                message.append(foreignKey);
                message.append("\u306e\u66f4\u65b0\u306e\u901a\u77e5\u3092\u518d\u958b\u3057\u307e\u3059\u3002");
                this.sendMessage(user, message.toString());
                break;
            }
            case 7: {
                IUser active = user;
                IUser passive = directoryLogic.getUserByForeignKey(foreignKey);
                this.updateFriendshipNotify(user, passive, false);
                StringBuilder message = new StringBuilder();
                message.append(foreignKey);
                message.append("\u306e\u66f4\u65b0\u306e\u901a\u77e5\u3092\u505c\u6b62\u3057\u307e\u3059\u3002");
                this.sendMessage(user, message.toString());
                break;
            }
            case 8: {
                device.setAvailabilityType(AvailabilityType.OFF);
                this.getShovelLogic().updateDevice(device);
                StringBuilder message = new StringBuilder();
                message.append("\u30c7\u30d0\u30a4\u30b9\u3078\u306e\u901a\u77e5\u3092\u505c\u6b62\u3057\u307e\u3059\u3002\n");
                message.append("\u901a\u77e5\u3092\u518d\u958b\u3057\u305f\u3044\u3068\u304d\u306f\"on\"\u3092\u9001\u3063\u3066\u304f\u3060\u3055\u3044\u3002");
                this.sendMessage(user, message.toString());
                break;
            }
            case 9: {
                device.setAvailabilityType(AvailabilityType.ON);
                this.getShovelLogic().updateDevice(device);
                StringBuilder message = new StringBuilder();
                message.append("\u30c7\u30d0\u30a4\u30b9\u3078\u306e\u901a\u77e5\u3092\u518d\u958b\u3057\u307e\u3059\u3002\n");
                message.append("\u901a\u77e5\u3092\u505c\u6b62\u3057\u305f\u3044\u3068\u304d\u306f\"off\"\u3092\u9001\u3063\u3066\u304f\u3060\u3055\u3044\u3002");
                this.sendMessage(user, message.toString());
                break;
            }
        }
    }

    IFriendship updateFriendshipNotify(IUser active, IUser passive, boolean notify) throws ApplicationException {
        IFriendship friend = this.getShovelLogic().getFriendship(active.getUserId(), passive.getUserId());
        if (friend == null) {
            throw new ApplicationException("");
        }
        int result = this.getShovelLogic().updateFriendshipNotify(active.getUserId(), passive.getForeignKey(), notify);
        if (result != 1) {
            throw new ApplicationException("");
        }
        return friend;
    }

    IFriendship createFriendship(IUser active, IUser passive) throws ApplicationException {
        long passiveId;
        if (passive == null) {
            throw new ApplicationException("");
        }
        long activeId = active.getUserId();
        if (activeId == (passiveId = passive.getUserId())) {
            throw new ApplicationException("");
        }
        IFriendship[] friendships = this.getShovelLogic().getRequests(passiveId, activeId);
        if (friendships == null) {
            throw new ApplicationException("");
        }
        IFriendship friend = null;
        IFriendship follower = null;
        for (IFriendship tmp : friendships) {
            if (tmp.getPassiveId() == passiveId) {
                friend = tmp;
                continue;
            }
            follower = tmp;
        }
        long time = Calendar.getInstance().getTimeInMillis();
        boolean accept = false;
        if (follower != null && follower.getRemovedTime() == 0L) {
            accept = true;
            if (active.isProtect() && follower == null && (follower = this.getShovelLogic().createFriendship(active.getUserId(), passive.getUserId(), accept, time)) == null) {
                throw new ApplicationException("");
            }
        }
        if (friend == null) {
            friend = this.getShovelLogic().createFriendship(active.getUserId(), passive.getUserId(), accept, time);
            if (friend == null) {
                throw new ApplicationException("");
            }
        } else {
            long[] friendshipIds = follower != null && follower.getRemovedTime() == 0L ? new long[]{friend.getFriendshipId(), follower.getFriendshipId()} : new long[]{friend.getFriendshipId()};
            int result = this.getShovelLogic().updateFriendships(friendshipIds, accept, time, true, 0L);
            if (result != friendshipIds.length) {
                throw new ApplicationException("");
            }
            friend.setAccept(accept);
            friend.setCreatedTime(time);
            friend.setNotify(true);
            friend.setRemovedTime(0L);
        }
        return friend;
    }

    IFriendship destroyFriendship(IUser active, IUser passive) throws ApplicationException {
        int result;
        if (passive == null) {
            throw new ApplicationException("");
        }
        long activeId = active.getUserId();
        long passiveId = passive.getUserId();
        IFriendship[] friendships = this.getShovelLogic().getRequests(passiveId, activeId);
        if (friendships == null || friendships.length > 2) {
            throw new ApplicationException("");
        }
        IFriendship friend = null;
        IFriendship follower = null;
        for (IFriendship tmp : friendships) {
            if (tmp.getPassiveId() == passiveId) {
                friend = tmp;
                continue;
            }
            follower = tmp;
        }
        if (friend == null) {
            throw new ApplicationException("");
        }
        long time = Calendar.getInstance().getTimeInMillis();
        if (follower != null && active.isProtect()) {
            long[] friendshipIds = new long[]{friend.getFriendshipId(), follower.getFriendshipId()};
            result = this.getShovelLogic().updateFriendships(friendshipIds, false, 0L, false, time);
        } else {
            friend.setAccept(false);
            friend.setCreatedTime(0L);
            friend.setNotify(false);
            friend.setRemovedTime(time);
            result = this.getShovelLogic().updateFriendship(friend);
            if (follower != null) {
                follower.setAccept(false);
                result += this.getShovelLogic().updateFriendship(follower);
            }
        }
        if (result != friendships.length) {
            throw new ApplicationException("");
        }
        return friend;
    }

    String getDeviceTypeWrapper() {
        return this.getDeviceType();
    }

    void sendMessage(IStatus status) throws ApplicationException {
        boolean nextPage;
        long senderId = status.getSenderId();
        long receiverId = status.getReferenceSenderId();
        IUser sender = this.getDirectoryLogic().getUser(senderId);
        Object[] args = new Object[]{sender.getForeignKey(), status.getBody()};
        MessageFormat formatter = new MessageFormat(bodyFormat_);
        String body = formatter.format(args);
        IUser receiver = this.getDirectoryLogic().getUser(receiverId);
        if (receiver != null) {
            this.replyMessage(sender, receiver, body);
            return;
        }
        HashSet<Long> userIdSet = new HashSet<Long>();
        if (this.isRepeat()) {
            IDevice device = sender.getDevice();
            if (this.getDeviceType().compareToIgnoreCase(device.getType()) == 0 && device.getAvailabilityType() == AvailabilityType.ON) {
                userIdSet.add(senderId);
            }
        }
        int offset = 0;
        int limit = 50;
        do {
            nextPage = false;
            Object[] follows = this.getShovelLogic().getFollowers(senderId, this.getDeviceTypeWrapper(), offset, limit + 1);
            if (follows != null && follows.length > 0) {
                boolean bl = nextPage = follows.length > limit;
                if (nextPage) {
                    offset += limit;
                    follows = (IFriendship[])ArrayUtils.subarray((Object[])follows, (int)0, (int)limit);
                }
                for (Object follow : follows) {
                    long userId = follow.getActiveId();
                    userIdSet.add(userId);
                }
            }
            userIdSet.remove(0);
            long[] userIds = ArrayUtils.toPrimitive((Long[])userIdSet.toArray(new Long[userIdSet.size()]));
            IUser[] users = this.getDirectoryLogic().getUsers(userIds);
            if (users == null || users.length <= 0) {
                return;
            }
            for (IUser user : users) {
                this.sendMessage(user, body);
            }
        } while (nextPage);
    }

    abstract void login() throws ApplicationException;

    abstract void logout();

    public void connect() throws ApplicationException {
        this.login();
        MessengerMain main = this.getMessengerMain();
        main.setMessengerWrapper((IAbstractDeviceWrapper)this);
        main.start();
    }

    public void disconnect() {
        this.logout();
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    S2Container getContainer() {
        return this.container_;
    }

    IDirectoryLogic getDirectoryLogic() {
        return (IDirectoryLogic)this.getContainer().getComponent(IDirectoryLogic.class);
    }

    IShovelLogic getShovelLogic() {
        return (IShovelLogic)this.getContainer().getComponent(IShovelLogic.class);
    }

    MessengerMain getMessengerMain() {
        return (MessengerMain)this.getContainer().getComponent(MessengerMain.class);
    }
}

