/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.device.impl;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import jp.sourceforge.shovel.GrowlPriorityType;
import jp.sourceforge.shovel.GrowlType;
import jp.sourceforge.shovel.device.IGrowlWrapper;
import jp.sourceforge.shovel.device.impl.AbstractDeviceWrapperImpl;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IGrowlPacket;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IGrowlLogic;
import org.seasar.framework.log.Logger;

public class GrowlWrapperImpl
extends AbstractDeviceWrapperImpl
implements IGrowlWrapper {
    static Logger logger = Logger.getLogger(GrowlWrapperImpl.class);
    BlockingQueue<Object> queue_;

    public String getDeviceType() {
        return "growl";
    }

    public String getDeviceTypeWrapper() {
        return null;
    }

    public String getAddress() {
        return null;
    }

    public boolean isSettings() {
        return false;
    }

    public void setProperty(String key, String value) {
    }

    public void login() throws ApplicationException {
        if (this.queue_ == null) {
            this.queue_ = new SynchronousQueue();
        }
    }

    public void logout() {
    }

    public boolean isConnected() {
        return true;
    }

    boolean isRepeat() {
        return false;
    }

    public void pushMessage(IStatus status) throws ApplicationException {
        try {
            this.queue_.put(status);
        }
        catch (InterruptedException e) {
            throw new ApplicationException("");
        }
    }

    public void dispatch() throws ApplicationException {
        try {
            Object o = this.queue_.take();
            this.sendMessage((IStatus)o);
        }
        catch (InterruptedException e) {
            throw new ApplicationException("");
        }
    }

    void sendMessage(IUser receiver, String body) throws ApplicationException {
        if (!receiver.isGrowl()) {
            return;
        }
        try {
            IGrowlLogic logic = (IGrowlLogic)this.getContainer().getComponent(IGrowlLogic.class);
            IGrowlPacket packet = logic.createPacket("Shovel", GrowlType.NOTIFICATION, "Updated Status", "Updated Status", body, GrowlPriorityType.NORMAL, false, receiver.getGrowlPassword());
            logic.sendPacket(receiver.getGrowlHost(), packet);
        }
        catch (ApplicationException applicationException) {
            // empty catch block
        }
    }

    void replyMessage(IUser sender, IUser receiver, String body) throws ApplicationException {
        IFriendship follower = this.getShovelLogic().getFriendship(receiver.getUserId(), sender.getUserId());
        if (sender.isProtect() && !follower.isAccept()) {
            return;
        }
        this.sendMessage(receiver, body);
    }
}

