/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.device.impl;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import javax.net.SocketFactory;
import jp.sourceforge.shovel.AvailabilityType;
import jp.sourceforge.shovel.ServicePropertyType;
import jp.sourceforge.shovel.device.IXmppWrapper;
import jp.sourceforge.shovel.device.impl.AbstractDeviceWrapperImpl;
import jp.sourceforge.shovel.device.impl.XmppWrapperImpl;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.ChatManager;
import org.jivesoftware.smack.ChatManagerListener;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.MessageListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.collections.ReferenceMap;
import org.jivesoftware.smackx.packet.ChatStateExtension;
import org.jivesoftware.smackx.packet.MessageEvent;
import org.seasar.framework.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmppWrapperImpl
extends AbstractDeviceWrapperImpl
implements IXmppWrapper {
    static Logger logger = Logger.getLogger(XmppWrapperImpl.class);
    String host_;
    String userId_;
    String password_;
    int port_;
    String serviceName_;
    boolean sasl_;
    boolean ssl_;
    String deviceType_;
    static final String NS_MESSAGE_EVENT = "jabber:x:event";
    static final String NS_CHAT_STATE = "http://jabber.org/protocol/chatstates";
    BlockingQueue<Object> queue_;
    Map<String, Chat> chatsByJabber_ = new ReferenceMap(0, 2);
    XMPPConnection connection_;

    public String getHost() {
        return this.host_;
    }

    public void setHost(String host) {
        this.host_ = host;
    }

    public String getUserId() {
        return this.userId_;
    }

    public void setUserId(String userId) {
        this.userId_ = userId;
    }

    public String getPassword() {
        return this.password_;
    }

    public void setPassword(String password) {
        this.password_ = password;
    }

    public int getPort() {
        return this.port_;
    }

    public void setPort(int port) {
        this.port_ = port;
    }

    public String getServiceName() {
        return this.serviceName_;
    }

    public void setServiceName(String serviceName) {
        this.serviceName_ = serviceName;
    }

    public boolean isSasl() {
        return this.sasl_;
    }

    public void setSasl(boolean sasl) {
        this.sasl_ = sasl;
    }

    public boolean isSsl() {
        return this.ssl_;
    }

    public void setSsl(boolean ssl) {
        this.ssl_ = ssl;
    }

    public void setDeviceType(String deviceType) {
        this.deviceType_ = deviceType;
    }

    public String getDeviceType() {
        return this.deviceType_;
    }

    public String getAddress() {
        StringBuilder address = new StringBuilder(this.getUserId());
        address.append("@");
        address.append(this.getServiceName());
        return address.toString();
    }

    public boolean isSettings() {
        return true;
    }

    public void setProperty(String key, String value) {
        switch (1.$SwitchMap$jp$sourceforge$shovel$ServicePropertyType[ServicePropertyType.find((String)key).ordinal()]) {
            case 1: {
                this.setDeviceType(value);
                break;
            }
            case 2: {
                this.setDisplayName(value);
                break;
            }
            case 3: {
                this.setHost(value);
                break;
            }
            case 4: {
                this.setPort(Integer.valueOf(value).intValue());
                break;
            }
            case 5: {
                this.setSasl(Boolean.valueOf(value).booleanValue());
                break;
            }
            case 6: {
                this.setSsl(Boolean.valueOf(value).booleanValue());
                break;
            }
            case 7: {
                this.setServiceName(value);
                break;
            }
            case 8: {
                this.setUserId(value);
                break;
            }
            case 9: {
                this.setPassword(value);
                break;
            }
        }
    }

    String splitJabberId(Chat chat) {
        String jabberId = chat.getParticipant();
        int endIndex = jabberId.lastIndexOf("/");
        if (endIndex == -1) {
            return jabberId;
        }
        return jabberId.substring(0, endIndex);
    }

    String splitClientId(Chat chat) {
        String jabberId = chat.getParticipant();
        int endIndex = jabberId.lastIndexOf("/");
        if (endIndex == -1) {
            return jabberId;
        }
        return jabberId.substring(endIndex);
    }

    public void chatCreated(Chat chat, boolean createdLocally) {
        chat.addMessageListener((MessageListener)this);
    }

    public void processMessage(Chat chat, Message message) {
        MessageEvent msgEvent = (MessageEvent)message.getExtension(NS_MESSAGE_EVENT);
        ChatStateExtension chatState = (ChatStateExtension)message.getExtension(NS_CHAT_STATE);
        try {
            boolean post = false;
            if (msgEvent == null) {
                if (chatState.getElementName() == "active") {
                    post = true;
                }
            } else if (msgEvent.isComposing() && (chatState == null || chatState.getElementName() == "active")) {
                post = true;
            }
            if (post) {
                String address = this.splitJabberId(chat).toLowerCase();
                this.chatsByJabber_.put(address, chat);
                this.receiveMessage(address, message.getBody());
            }
        }
        catch (ApplicationException e) {
            // empty catch block
        }
    }

    public void entriesAdded(Collection<String> addresses) {
    }

    public void entriesUpdated(Collection<String> addresses) {
    }

    public void entriesDeleted(Collection<String> addresses) {
    }

    public void presenceChanged(Presence presence) {
    }

    public void login() throws ApplicationException {
        if (this.queue_ == null) {
            this.queue_ = new SynchronousQueue();
        }
        ConnectionConfiguration config = this.host_ != null && this.port_ > 0 ? (this.serviceName_ == null ? new ConnectionConfiguration(this.host_, this.port_) : new ConnectionConfiguration(this.host_, this.port_, this.serviceName_)) : new ConnectionConfiguration(this.serviceName_);
        try {
            if (this.sasl_) {
                config.setSASLAuthenticationEnabled(true);
            }
            if (this.ssl_) {
                config.setSocketFactory((SocketFactory)new MySSLSocketFactory());
            }
            this.connection_ = new XMPPConnection(config);
            this.connection_.connect();
            this.connection_.login(this.getUserId(), this.getPassword());
        }
        catch (XMPPException e) {
            throw new ApplicationException("");
        }
        ChatManager chatManager = this.connection_.getChatManager();
        chatManager.addChatListener((ChatManagerListener)this);
        Roster roster = this.connection_.getRoster();
        roster.setSubscriptionMode(Roster.SubscriptionMode.accept_all);
    }

    public void logout() {
        this.connection_ = null;
    }

    public void pushMessage(IStatus status) throws ApplicationException {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.queue_.put(status);
        }
        catch (InterruptedException e) {
            throw new ApplicationException("");
        }
    }

    public void dispatch() throws ApplicationException {
        if (!this.isConnected()) {
            return;
        }
        try {
            Object o = this.queue_.take();
            this.sendMessage((IStatus)o);
        }
        catch (InterruptedException e) {
            throw new ApplicationException("");
        }
    }

    public boolean isConnected() {
        return this.connection_ != null && this.connection_.isConnected();
    }

    void sendMessage(IUser receiver, String body) throws ApplicationException {
        IDevice device = receiver.getDevice();
        if (this.getDeviceType().compareToIgnoreCase(device.getType()) == 0 && device.getAvailabilityType() == AvailabilityType.ON) {
            String address = receiver.getAddress();
            if (address == null || address.length() <= 0) {
                return;
            }
            try {
                Message message = new Message();
                message.setTo(address);
                message.setBody(body);
                String to = message.getTo();
                Chat chat = (Chat)this.chatsByJabber_.get(to);
                if (chat == null) {
                    ChatManager chatManager = this.connection_.getChatManager();
                    chat = chatManager.createChat(to, (MessageListener)this);
                }
                chat.sendMessage(message);
            }
            catch (XMPPException e) {
                throw new ApplicationException("");
            }
        }
    }
}

