/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.entity.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import jp.sourceforge.shovel.SizeType;
import jp.sourceforge.shovel.entity.IMimeType;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.entity.ISize;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IMimeTypeLogic;
import jp.sourceforge.shovel.logic.IServerFileLogic;
import jp.sourceforge.shovel.util.ServerFileUtil;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.seasar.dao.annotation.tiger.Bean;
import org.seasar.dao.annotation.tiger.Id;
import org.seasar.dao.annotation.tiger.IdType;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

@Bean(table="serverfiles")
public class ServerFileImpl
implements IServerFile {
    String charset_;
    String mime_;
    String name_;
    long serverFileId_;
    int size_;
    long createdTime_;
    String contentType_;
    IServerFileLogic serverFileLogic_;
    File temp_;
    File[] thumbnail_;
    File temporaryThumbnail_;
    File file_ = null;
    ISize full_ = (ISize)this.getContainer().getComponent(ISize.class);
    Map<SizeType, ISize> sizeMap_ = new HashMap();
    ServletContext application_;

    public String getCharset() {
        return this.charset_;
    }

    public void setCharset(String charset) {
        this.charset_ = charset;
    }

    public String getMime() {
        return this.mime_;
    }

    public void setMime(String mime) {
        this.mime_ = mime;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public long getServerFileId() {
        return this.serverFileId_;
    }

    @Id(value=IdType.IDENTITY)
    public void setServerFileId(long serverFileId) {
        this.serverFileId_ = serverFileId;
    }

    public int getSize() {
        return this.size_;
    }

    public void setSize(int size) {
        this.size_ = size;
    }

    public long getCreatedTime() {
        return this.createdTime_;
    }

    public void setCreatedTime(long createdTime) {
        this.createdTime_ = createdTime;
    }

    public String getContentType() {
        return this.contentType_;
    }

    public void setContentType(String contentType) {
        this.contentType_ = contentType;
    }

    S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }

    /*
     * Loose catch block
     */
    void copy(InputStream inputStream, OutputStream outputStream) throws ApplicationException {
        block19: {
            int size;
            ApplicationException e = null;
            byte[] buffer = new byte[4096];
            while ((size = inputStream.read(buffer, 0, 4096)) > 0) {
                outputStream.write(buffer, 0, size);
            }
            Object var7_7 = null;
            IOException cause1 = null;
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException cause2) {
                cause1 = cause2;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException cause2) {
                IOException iOException = cause1 = cause1 == null ? cause2 : cause1;
            }
            if (e == null && cause1 != null) {
                e = new ApplicationException("");
                e.initCause((Throwable)cause1);
                throw e;
            }
            break block19;
            {
                catch (IOException cause) {
                    e = new ApplicationException("");
                    e.initCause((Throwable)cause);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                cause1 = null;
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException cause2) {
                    cause1 = cause2;
                }
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException cause2) {
                    IOException iOException = cause1 = cause1 == null ? cause2 : cause1;
                }
                if (e == null && cause1 != null) {
                    e = new ApplicationException("");
                    e.initCause((Throwable)cause1);
                    throw e;
                }
                throw throwable;
            }
        }
    }

    public boolean isExists(SizeType sizeType) throws ApplicationException {
        if (sizeType.isOriginal()) {
            return false;
        }
        String path = ServerFileUtil.formatPath(null, (String)this.getThumbnailDir(sizeType), (long)this.getServerFileId(), (boolean)true);
        File file = new File(path);
        return file.exists();
    }

    /*
     * Loose catch block
     */
    public void commit(int process) throws ApplicationException {
        switch (process) {
            case 0: {
                InputStream inputStream = null;
                OutputStream outputStream = null;
                ApplicationException e = null;
                if (this.thumbnail_ != null) {
                    for (SizeType sizeType : SizeType.values()) {
                        if (sizeType.isOriginal()) continue;
                        String path = ServerFileUtil.formatPath(null, (String)this.getThumbnailDir(sizeType), (long)this.getServerFileId(), (boolean)true);
                        FileUtils.copyFile((File)this.thumbnail_[sizeType.getIndex()], (File)new File(path));
                    }
                }
                String fileName = ServerFileUtil.formatPath(null, (String)this.getFileDir(), (long)this.getServerFileId(), (boolean)true);
                outputStream = new FileOutputStream(fileName);
                inputStream = this.getInputStream();
                this.copy(inputStream, outputStream);
                Object var13_21 = null;
                IOException cause1 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException cause2) {
                    cause1 = cause2;
                }
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException cause2) {
                    IOException iOException = cause1 = cause1 == null ? cause2 : cause1;
                }
                if (e != null || cause1 == null) break;
                e = new ApplicationException("");
                e.initCause((Throwable)cause1);
                throw e;
                {
                    catch (IOException cause) {
                        for (SizeType sizeType : SizeType.values()) {
                            String path;
                            File file;
                            if (sizeType.isOriginal() || !(file = new File(path = ServerFileUtil.formatPath(null, (String)this.getThumbnailDir(sizeType), (long)this.getServerFileId(), (boolean)true))).exists()) continue;
                            file.delete();
                        }
                        e = new ApplicationException("");
                        e.initCause((Throwable)cause);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_22 = null;
                    cause1 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException cause2) {
                        cause1 = cause2;
                    }
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException cause2) {
                        IOException iOException = cause1 = cause1 == null ? cause2 : cause1;
                    }
                    if (e == null && cause1 != null) {
                        e = new ApplicationException("");
                        e.initCause((Throwable)cause1);
                        throw e;
                    }
                    throw throwable;
                }
            }
            case 1: {
                for (SizeType sizeType : SizeType.values()) {
                    if (sizeType.isOriginal()) continue;
                    String path = ServerFileUtil.formatPath(null, (String)this.getThumbnailDir(sizeType), (long)this.getServerFileId(), (boolean)false);
                    File file = new File(path);
                    file.delete();
                }
                String path = ServerFileUtil.formatPath(null, (String)this.getFileDir(), (long)this.getServerFileId(), (boolean)false);
                File file = new File(path);
                file.delete();
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
    }

    public void commit(SizeType sizeType) throws ApplicationException {
        if (sizeType.isOriginal()) {
            return;
        }
        try {
            String path = ServerFileUtil.formatPath(null, (String)this.getThumbnailDir(sizeType), (long)this.getServerFileId(), (boolean)true);
            FileUtils.copyFile((File)this.thumbnail_[sizeType.getIndex()], (File)new File(path));
        }
        catch (IOException cause) {
            String path = ServerFileUtil.formatPath(null, (String)this.getThumbnailDir(sizeType), (long)this.getServerFileId(), (boolean)true);
            File serverFile = new File(path);
            if (serverFile.exists()) {
                serverFile.delete();
            }
            ApplicationException e = new ApplicationException("");
            e.initCause((Throwable)cause);
            throw e;
        }
    }

    public void remove() throws Exception {
        long[] serverFileIds = new long[]{this.getServerFileId()};
        this.serverFileLogic_.removeServerFiles(serverFileIds);
    }

    public void download(OutputStream outputStream, SizeType sizeType) throws ApplicationException {
        ServerFileUtil.prepareDownload((IServerFile)this);
        InputStream inputStream = this.getInputStream(sizeType);
        this.copy(inputStream, outputStream);
        try {
            inputStream.close();
        }
        catch (IOException cause) {
            ApplicationException e = new ApplicationException("");
            e.initCause((Throwable)cause);
            throw e;
        }
    }

    IMimeTypeLogic getMimeTypeLogic() {
        return (IMimeTypeLogic)this.getContainer().getComponent(IMimeTypeLogic.class);
    }

    public void createThumbnail(SizeType sizeType) throws ApplicationException {
        if (sizeType.isOriginal()) {
            return;
        }
        try {
            String raw;
            IMimeType mime = this.getMimeTypeLogic().getMimeTypeByFileName(this.getName());
            if (this.getMime() == null) {
                throw new ApplicationException("");
            }
            String[] tokens = this.temp_.getName().split("\\.");
            StringBuilder path = null;
            if (tokens.length <= 1) {
                path = new StringBuilder(this.temp_.getPath());
                path.append(".");
                path.append(mime.getExtension());
            } else if (tokens[tokens.length - 1].compareToIgnoreCase(mime.getExtension()) != 0) {
                path = new StringBuilder(this.temp_.getParent());
                path.append(File.separator);
                for (int i = 0; i < tokens.length - 1; ++i) {
                    path.append(tokens[i]);
                    if (i >= tokens.length - 2) continue;
                    path.append(".");
                }
                path.append(mime.getExtension());
            }
            if (path != null && path.toString().compareTo(this.temp_.getPath()) != 0) {
                File tempFile = new File(path.toString());
                FileUtils.copyFile((File)this.temp_, (File)tempFile);
                this.temp_ = tempFile;
            }
            String input = this.temp_.getPath();
            File dir = new File(System.getProperty("java.io.tmpdir"));
            File tempFile = File.createTempFile("", "_" + sizeType.getId(), dir);
            String withExt = raw = tempFile.getPath();
            int index = raw.lastIndexOf(".");
            if (index < 0) {
                withExt = raw;
            } else {
                withExt = raw.substring(0, index);
                withExt = withExt + ".jpeg";
            }
            tempFile.delete();
            String output = withExt;
            if (SystemUtils.IS_OS_WINDOWS) {
                input = String.format("\"%s\"", input);
                output = String.format("\"%s\"", withExt);
            }
            Properties props = (Properties)this.getContainer().getComponent((Object)"commonProperties");
            String size = String.valueOf(sizeType.getPx());
            String[] cmd = new String[]{props.getProperty("imagemagick.bin"), input, "-coalesce", "-resize", size + "x" + size, "-deconstruct", output};
            ProcessBuilder builder = new ProcessBuilder(cmd);
            if (SystemUtils.IS_OS_LINUX) {
                Map<String, String> env = builder.environment();
                env.put("LD_LIBRARY_PATH", props.getProperty("imagemagick.lib"));
            }
            Process proc = builder.start();
            proc.waitFor();
            int result = proc.exitValue();
            if (result != 0) {
                throw new ApplicationException("");
            }
            if (this.thumbnail_ == null) {
                this.thumbnail_ = new File[4];
            }
            this.thumbnail_[sizeType.getIndex()] = new File(raw);
            new File(withExt).renameTo(this.thumbnail_[sizeType.getIndex()]);
        }
        catch (InterruptedException cause) {
            ApplicationException e = new ApplicationException("");
            e.initCause((Throwable)cause);
            throw e;
        }
        catch (IOException cause) {
            ApplicationException e = new ApplicationException("");
            e.initCause((Throwable)cause);
            throw e;
        }
    }

    public void createTemporaryThumbnail(SizeType sizeType) throws ApplicationException {
        if (sizeType.isOriginal()) {
            return;
        }
        try {
            BufferedImage src = ServerFileUtil.getBufferedImage((IServerFile)this);
            if (src == null) {
                return;
            }
            ISize size = (ISize)this.getContainer().getComponent(ISize.class);
            size.setWidth(src.getWidth());
            size.setHeight(src.getHeight());
            int px = sizeType.getPx();
            size = size.computeFitSize(px, px);
            int x = (px - size.getWidth()) / 2;
            int y = (px - size.getHeight()) / 2;
            int imageType = src.getType();
            if (imageType == 0) {
                if (this.getMime().compareTo("image/png") == 0 || this.getMime().compareTo("image/x-png") == 0) {
                    imageType = 1;
                } else {
                    throw new ApplicationException("");
                }
            }
            BufferedImage memory = new BufferedImage(sizeType.getPx(), sizeType.getPx(), imageType);
            Graphics2D graphics = memory.createGraphics();
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, px, px);
            Image img = src.getScaledInstance(size.getWidth(), size.getHeight(), 16);
            graphics.drawImage(img, x, y, null);
            if (this.thumbnail_ == null) {
                this.thumbnail_ = new File[4];
            }
            this.thumbnail_[sizeType.getIndex()] = File.createTempFile("tmp_thumb_", null);
            ImageIO.write((RenderedImage)memory, "jpeg", this.thumbnail_[sizeType.getIndex()]);
        }
        catch (IOException e) {
            throw new ApplicationException("");
        }
    }

    public InputStream getInputStream() throws ApplicationException {
        return this.getInputStream(null);
    }

    InputStream getInputStream(SizeType sizeType) throws ApplicationException {
        InputStream inputStream = null;
        try {
            if (this.temp_ == null) {
                String baseDir = sizeType == null || sizeType.isOriginal() ? this.getFileDir() : this.getThumbnailDir(sizeType);
                String name = ServerFileUtil.formatPath(null, (String)baseDir, (long)this.getServerFileId(), (boolean)false);
                inputStream = new FileInputStream(name);
            } else {
                inputStream = new FileInputStream(this.temp_);
            }
        }
        catch (IOException cause1) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
            catch (IOException cause2) {
                cause1 = cause2;
            }
            ApplicationException e = new ApplicationException("");
            e.initCause((Throwable)cause1);
            throw e;
        }
        return inputStream;
    }

    @Binding(bindingType=BindingType.NONE)
    public void setInputStream(InputStream inputStream) throws ApplicationException {
        FileOutputStream outputStream = null;
        try {
            this.temp_ = File.createTempFile("temp_", null);
            outputStream = new FileOutputStream(this.temp_);
            this.copy(inputStream, (OutputStream)outputStream);
        }
        catch (IOException cause) {
            ApplicationException e = new ApplicationException("");
            e.initCause((Throwable)cause);
            throw e;
        }
    }

    public boolean isImage() {
        return this.getWidth() > 0 && this.getHeight() > 0;
    }

    public void prepare() throws ApplicationException {
        BufferedImage image = ServerFileUtil.getBufferedImage((IServerFile)this);
        if (image == null) {
            return;
        }
        this.setWidth(image.getWidth());
        this.setHeight(image.getHeight());
    }

    public void prepareForView() {
        for (SizeType sizeType : SizeType.values()) {
            int x;
            int y = x = sizeType.getPx();
            if (sizeType.isOriginal()) {
                y = -1;
            }
            ISize size = this.full_.computeFitSize(x, y);
            this.sizeMap_.put(sizeType, size);
        }
    }

    public int getWidth() {
        return this.full_.getWidth();
    }

    public void setWidth(int width) {
        this.full_.setWidth(width);
    }

    public int getHeight() {
        return this.full_.getHeight();
    }

    public void setHeight(int height) {
        this.full_.setHeight(height);
    }

    public ISize getOriginal() {
        return (ISize)this.sizeMap_.get(SizeType.ORIGINAL);
    }

    public ISize getSmall() {
        return (ISize)this.sizeMap_.get(SizeType.SMALL);
    }

    public ISize getMiddle() {
        return (ISize)this.sizeMap_.get(SizeType.MIDDLE);
    }

    public ISize getLarge() {
        return (ISize)this.sizeMap_.get(SizeType.LARGE);
    }

    public ISize getXlarge() {
        return (ISize)this.sizeMap_.get(SizeType.X_LARGE);
    }

    public boolean isExists() {
        String name = this.getName();
        return name != null && name.length() > 0;
    }

    String getFileDir() {
        return "serverFile";
    }

    String getThumbnailDir(SizeType sizeType) {
        if (sizeType.isOriginal()) {
            return null;
        }
        StringBuilder dir = new StringBuilder();
        dir.append("thumbnail");
        dir.append(File.separator);
        dir.append(String.format("%1$s", sizeType.getId()));
        return dir.toString();
    }

    public Object clone() {
        return null;
    }

    public void setApplication(ServletContext application) {
        this.application_ = application;
    }

    String getRealPath(String filename) {
        StringBuilder virtualPath = new StringBuilder();
        virtualPath.append("/shovel/image/");
        virtualPath.append(filename);
        return this.application_.getRealPath(virtualPath.toString());
    }
}

