/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.servlet.freemarker;

import freemarker.cache.TemplateLoader;
import freemarker.ext.servlet.FreemarkerServlet;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.entity.TokenProcessorWrapper;
import jp.sourceforge.shovel.servlet.freemarker.WebappTemplateLoaderExt;
import net.arnx.jsonic.JSON;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.ResourceUtil;

public class FreemarkerServletWrapper
extends FreemarkerServlet {
    static final long serialVersionUID = -1L;
    Configuration config_;
    ObjectWrapper wrapper_;

    public void init() throws ServletException {
        super.init();
        Configuration config = this.getConfiguration();
        config.setTemplateLoader((TemplateLoader)new WebappTemplateLoaderExt(this.getServletContext(), this.getTemplatePath()));
    }

    protected boolean preTemplateProcess(HttpServletRequest request, HttpServletResponse response, Template template, TemplateModel data) throws ServletException, IOException {
        String encoding = (String)request.getAttribute("encoding");
        if (encoding == null) {
            encoding = "UTF-8";
        }
        response.setCharacterEncoding(encoding);
        String mimeType = (String)request.getAttribute("mimeType");
        if (mimeType != null) {
            response.setContentType(mimeType + ";charset=" + encoding);
        }
        S2Container container = SingletonS2ContainerFactory.getContainer();
        Properties props = (Properties)container.getComponent((Object)"commonProperties");
        boolean debug = Boolean.parseBoolean(props.getProperty("debug", "false"));
        String webRoot = props.getProperty("webroot", "");
        String appPath = request.getContextPath();
        StringBuffer url = request.getRequestURL();
        String baseUrl = "";
        try {
            URI uri = new URI(url.toString());
            uri = new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), null, null, null);
            baseUrl = uri.toString();
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        request.setAttribute("debug", (Object)debug);
        request.setAttribute("webroot", (Object)webRoot);
        request.setAttribute("app_path", (Object)appPath);
        request.setAttribute("base_url", (Object)baseUrl);
        String version = (String)container.getComponent((Object)"version");
        if (debug || version == null) {
            long time = Calendar.getInstance().getTimeInMillis();
            version = String.valueOf(time);
        }
        request.setAttribute("version", (Object)version);
        String salt = String.valueOf(System.currentTimeMillis());
        String token = new TokenProcessorWrapper().generateToken(salt);
        String boundary = "__response_boundary__" + token;
        request.setAttribute("boundary", (Object)boundary);
        response.setHeader("X-Response-Boundary", boundary);
        HttpSession session = request.getSession();
        Locale requestLocale = request.getLocale();
        Locale sessionLocale = (Locale)session.getAttribute("org.apache.struts.action.LOCALE");
        if (requestLocale != sessionLocale) {
            session.setAttribute("org.apache.struts.action.LOCALE", (Object)requestLocale);
        }
        request.setAttribute("localeKey", (Object)"org.apache.struts.action.LOCALE");
        String path = "jp/sourceforge/shovel/js.properties";
        if (sessionLocale.getLanguage() != Locale.ENGLISH.getLanguage()) {
            StringBuilder pathBuilder = new StringBuilder("jp/sourceforge/shovel/js_");
            pathBuilder.append(sessionLocale.getLanguage());
            pathBuilder.append(".properties");
            if (ResourceUtil.isExist((String)pathBuilder.toString())) {
                path = pathBuilder.toString();
            }
        }
        props = ResourceUtil.getProperties((String)path);
        request.setAttribute("jsres", (Object)JSON.encode((Object)props));
        return super.preTemplateProcess(request, response, template, data);
    }

    protected Configuration createConfiguration() {
        this.config_ = super.createConfiguration();
        return this.config_;
    }

    protected ObjectWrapper createObjectWrapper() {
        this.wrapper_ = super.createObjectWrapper();
        S2Container container = SingletonS2ContainerFactory.getContainer();
        Map applicationScope = (Map)container.getComponent((Object)"applicationScope");
        applicationScope.put("freemarkerServlet", this);
        return this.wrapper_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StringBuffer processNow(String path, HttpServletRequest request, HttpServletResponse response) {
        StringWriter writer;
        block7: {
            ServletContext servletContext = this.getServletContext();
            writer = new StringWriter();
            try {
                Template template = this.config_.getTemplate(path);
                TemplateModel model = this.createModel(this.wrapper_, servletContext, request, response);
                if (!this.preTemplateProcess(request, response, template, model)) break block7;
                try {
                    template.process((Object)model, (Writer)writer);
                }
                finally {
                    this.postTemplateProcess(request, response, template, model);
                }
            }
            catch (IOException ex) {
            }
            catch (TemplateException ex) {
            }
            catch (ServletException ex) {
                // empty catch block
            }
        }
        return writer.getBuffer();
    }
}

