/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.util;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sourceforge.shovel.entity.IClient;
import jp.sourceforge.shovel.entity.IMimeType;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IMimeTypeLogic;
import jp.sourceforge.shovel.util.HttpUtil;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.struts.upload.FormFile;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class ServerFileUtil {
    static List<String> allowFormatNames_ = new ArrayList();
    static String root_;
    static final String[] defaultValidMimeTypes_;

    public static BufferedImage getBufferedImage(IServerFile serverFile) throws ApplicationException {
        try {
            ImageInputStream is = ImageIO.createImageInputStream(serverFile.getInputStream());
            IMimeType mimeType = ServerFileUtil.getMimeTypeLogic().getMimeTypeByFileName(serverFile.getName());
            String mime = mimeType == null ? serverFile.getMime() : mimeType.getMimeType();
            Iterator<ImageReader> i = ImageIO.getImageReadersByMIMEType(mime);
            BufferedImage image = null;
            while (i.hasNext()) {
                String formatName;
                ImageReader reader = i.next();
                reader.setInput(is, true);
                image = reader.read(reader.getMinIndex());
                if (image == null || !allowFormatNames_.contains(formatName = reader.getFormatName().toLowerCase())) continue;
                break;
            }
            return image;
        }
        catch (IOException cause) {
            ApplicationException e = new ApplicationException("");
            e.initCause((Throwable)cause);
            throw e;
        }
    }

    static S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }

    static IMimeTypeLogic getMimeTypeLogic() {
        S2Container container = ServerFileUtil.getContainer();
        return (IMimeTypeLogic)container.getComponent(IMimeTypeLogic.class);
    }

    static Properties getCommonProperties() {
        return (Properties)ServerFileUtil.getContainer().getComponent((Object)"commonProperties");
    }

    public static boolean isText(String mimeType) {
        return mimeType.startsWith("text/");
    }

    public static void prepareDownload(IServerFile serverFile) throws ApplicationException {
        HttpServletRequest request = (HttpServletRequest)ServerFileUtil.getContainer().getComponent((Object)"request");
        String userAgent = request.getHeader("User-Agent").toLowerCase();
        IClient client = HttpUtil.detectClient((String)userAgent);
        IMimeTypeLogic mimeTypeManager = ServerFileUtil.getMimeTypeLogic();
        String fileName = serverFile.getName();
        IMimeType mimeType = mimeTypeManager.getMimeType(".jpeg");
        StringBuilder disposition = new StringBuilder("attachment");
        HttpServletResponse response = (HttpServletResponse)ServerFileUtil.getContainer().getComponent((Object)"response");
        disposition.append("; filename=\"");
        disposition.append(client.encodeText(fileName));
        disposition.append("\"");
        response.setHeader("Content-Disposition", disposition.toString());
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(serverFile.getCreatedTime());
        String time = DateUtil.formatDate((Date)calendar.getTime(), (String)"EEE, dd MMM yyyy HH:mm:ss zzz");
        response.setHeader("Last-Modified", time);
        calendar.set(1970, 1, 1, 0, 0, 0);
        time = DateUtil.formatDate((Date)calendar.getTime(), (String)"EEE, dd MMM yyyy HH:mm:ss zzz");
        response.setHeader("Expires", HttpUtil.getRFC1123Time((Date)calendar.getTime()));
        response.setContentType(mimeType.getMimeType());
    }

    static String getMimeType(String contentType, String fileName, String[] validMimeTypes) {
        String mimeType;
        if (contentType == null) {
            mimeType = ServerFileUtil.getMimeTypeLogic().getMimeTypeByFileName(fileName);
            contentType = mimeType == null ? "application/octet-stream" : mimeType.getMimeType();
        }
        mimeType = contentType;
        int pos = contentType.indexOf(";");
        if (pos >= 0) {
            mimeType = contentType.substring(0, pos);
        }
        if (validMimeTypes == null) {
            validMimeTypes = defaultValidMimeTypes_;
        }
        for (String validMimeType : validMimeTypes) {
            if (validMimeType.compareTo(mimeType) != 0) continue;
            return mimeType;
        }
        return null;
    }

    public static IServerFile toServerFile(FormFile formFile, String[] validMimeTypes, String charset) throws ApplicationException {
        String maxSize;
        String fileName = formFile.getFileName();
        String contentType = formFile.getContentType();
        String mimeType = ServerFileUtil.getMimeType((String)contentType, (String)fileName, null);
        if (mimeType == null) {
            throw new ApplicationException("");
        }
        int size = formFile.getFileSize();
        if (size > Integer.parseInt(maxSize = ServerFileUtil.getCommonProperties().getProperty("upload.maxSize")) * 1024) {
            throw new ApplicationException("");
        }
        InputStream inputStream = null;
        try {
            inputStream = formFile.getInputStream();
            if (inputStream == null) {
                return null;
            }
        }
        catch (IOException cause) {
            ApplicationException e = new ApplicationException("");
            e.initCause((Throwable)cause);
            throw e;
        }
        IServerFile serverFile = (IServerFile)ServerFileUtil.getContainer().getComponent(IServerFile.class);
        serverFile.setName(formFile.getFileName());
        serverFile.setMime(mimeType);
        serverFile.setSize(size);
        serverFile.setInputStream(inputStream);
        serverFile.setContentType(contentType);
        serverFile.setCharset(charset);
        return serverFile;
    }

    static String getRoot(String root) throws ApplicationException {
        root_ = root == null ? ServerFileUtil.getCommonProperties().getProperty("files.dir") : root;
        File dir = new File(root_);
        if (!dir.isDirectory() || !dir.canWrite()) {
            ApplicationException e = new ApplicationException("");
            e.setCauseArgs(dir.getPath());
            throw e;
        }
        return root_;
    }

    public static String formatPath(String rootDir, String baseDir, long fileId, boolean mkdir) throws ApplicationException {
        StringBuilder dirs = new StringBuilder(ServerFileUtil.getRoot((String)rootDir));
        dirs.append(File.separator);
        dirs.append(baseDir.toLowerCase());
        dirs.append(File.separator);
        String fileName = String.valueOf(fileId);
        int length = fileName.length();
        if (length > 6) {
            int limit = length - 6;
            dirs.append(fileName.substring(0, limit));
            dirs.append(File.separator);
            dirs.append(fileName.substring(limit, 3));
            fileName = fileName.substring(limit + 3, 3);
        } else if (length > 3) {
            int limit = length - 3;
            dirs.append("0");
            dirs.append(File.separator);
            dirs.append(fileName.substring(0, limit));
            fileName = fileName.substring(limit, 3);
        } else {
            dirs.append("0");
            dirs.append(File.separator);
            dirs.append("0");
        }
        File dir = new File(dirs.toString());
        if (mkdir) {
            if (!dir.isDirectory() && !dir.mkdirs()) {
                ApplicationException e = new ApplicationException("");
                e.setCauseArgs(dir.getPath());
                throw e;
            }
            if (!dir.canWrite()) {
                ApplicationException e = new ApplicationException("");
                e.setCauseArgs(dir.getPath());
                throw e;
            }
        } else if (!dir.isDirectory() || !dir.canWrite()) {
            ApplicationException e = new ApplicationException("");
            e.setCauseArgs(dir.getPath());
            throw e;
        }
        dirs.append(File.separator);
        dirs.append(fileName);
        String pathName = dirs.toString();
        File file = new File(pathName);
        if (file.isFile() && !file.canWrite()) {
            ApplicationException e = new ApplicationException("");
            e.setCauseArgs(file.getName());
            throw e;
        }
        return pathName;
    }

    static {
        allowFormatNames_.add("jpeg");
        allowFormatNames_.add("gif");
        allowFormatNames_.add("png");
        defaultValidMimeTypes_ = new String[]{"image/png", "image/x-png", "image/jpeg", "image/pjpeg", "image/gif", "application/octet-stream"};
    }
}

