<#macro userThumbnailUrl user>
  <#local serverFile=user.profileImage />
  <#if serverFile.exists>
    <#local html=JspTaglibs["http://struts.apache.org/tags-html-el"] />
    <@html.rewrite page="${base_url}/shovel_production/profile_images/${user.userId}/${serverFile.name}" /><#t />
  <#else>
    ${base_url}${webroot}/images/default_profile_large.png<#t />
  </#if>
</#macro>
<#macro userThumbnail user size="">
  <#local serverFile=user.profileImage />
  <#if serverFile.exists>
    <#local html=JspTaglibs["http://struts.apache.org/tags-html-el"] />
    <#local url><@html.rewrite page="/${user.foreignKey}/-/${size}/${serverFile.name}" /></#local>
    <#local fileName=serverFile.name />
    <#if size="original">
      <#assign width> width="${serverFile.original.width}"</#assign>
      <#assign height> height="${serverFile.original.height}"</#assign>
    </#if>
  <#else>
    <#local url>${webroot}/image/default_profile_${size}.png</#local>
    <#local fileName="default_profile_${size}.png" />
  </#if>
  <#if !(size=="original" && !serverFile.exists)>
<img src="${url}" title="${user.displayName?default('')}" style="vertical-align: middle;" alt="${fileName}"${width?default("")}${height?default("")}/><#t />
  </#if>
</#macro>
