<#assign common=JspTaglibs["/WEB-INF/tld/common.tld"]/>
<#assign core=JspTaglibs["http://java.sun.com/jsp/jstl/core"] />
<#assign html=JspTaglibs["http://struts.apache.org/tags-html-el"] />
<#import "/macro.ftl" as macro />
<#assign key="other" />
<#if login?has_content && login == user.foreignKey>
  <#assign key="your" />
</#if>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="ja" xml:lang="ja">
  <head>
<#if !protect?has_content>
  <#assign feed>
    <link rel="alternate" type="application/rss+xml" title="${user.displayName} (RSS)" href="<@html.rewrite page="/statuses/user_timeline/${user.userId}.rss" />" />
    <link rel="alternate" type="application/atom+xml" title="${user.displayName} (Atom)" href="<@html.rewrite page="/statuses/user_timeline/${user.userId}.atom" />" />
    <link rel="alternate" type="application/rss+xml" title="${user.displayName} and friends (RSS)" href="<@html.rewrite page="/statuses/friends_timeline/${user.userId}.rss" />" />
    <link rel="alternate" type="application/atom+xml" title="${user.displayName} and friends (Atom)" href="<@html.rewrite page="/statuses/friends_timeline/${user.userId}.atom" />" />
  </#assign>
  <#assign viewType=Session.listRefine.viewType />
</#if>
<@macro.head key=viewType.id arg1=user.foreignKey feed=feed?default("") />
<#include "people/urlList.ftl" />
  </head>
  <body id="people" class="yui-skin-sam">
    <div class="container-wrapper">
<#include "header.ftl" />
      <div class="flash" style="display: none;" id="people_flash"></div>
      <div class="container">
        <div class="content-wrapper">
          <div class="content">
            <form id="people_form">
              <input type="hidden" value="${viewType.id}" id="people_viewID" />
              <input type="hidden" name="method" value="page" id="people_method" />
              <input type="hidden" name="page" value="" id="people_page" />
              <input type="hidden" name="partial" value="" id="people_partial" />
              <input type="hidden" value="${protect?default(false)?string("true", "false")}" id="people_protect" />
              <input type="hidden" name="foreignKey" value="${user.foreignKey}" id="people_foreignKey" />

              <div class="currently-status">
                <h2 class="thumb">
<@macro.icon page="/account/profile_image/${user.foreignKey}" nopage="/account/picture" user=user size="xlarge" withName=true withLink=false />
                </h2>
                <div style="line-height: 0.7; margin-top: 2.2em;" id="people_content">
<#if protect?has_content>
  <p style="line-height: 1.2em; font-size: 2.12em; padding: 1em 0pt;">
    ステータスは公開されていません。<br/>
  <#if !user.remove && login?has_content>
    <#if follower?has_content>
      フォローを申し込まれています。<br/>
      <a href="#" onclick="return shovel.controller.acceptFriendRequest('${user.foreignKey}');">許可する</a>&nbsp;|&nbsp;<a href="#" onclick="return shovel.controller.denyFriendRequest('${user.foreignKey}');">拒否する</a>
    <#else>
      <span<#if friend?has_content> style="display: none;"</#if> id="people_createFriendship"><a href="#" onclick="return shovel.controller.createFriendship();">フォローをお願いする。</a></span>
      <span<#if !friend?has_content> style="display: none;"</#if> id="people_destroyFriendship">フォローをお願い中です。<a href="#" onclick="return shovel.controller.destroyFriendship();">キャンセルする</a></span>
    </#if>
  </#if>
  </p>
<#else>
  <#if !user.remove && login?has_content>
    <#if login != user.foreignKey>
                  <div>
                    <input type="button" value="フォローする" onclick="return shovel.controller.createFriendship();" <#if friend> style="display: none;"</#if> id="people_createFriendship" />
                    <input type="button" value="フォローしない" onclick="return shovel.controller.destroyFriendship();" <#if !friend> style="display: none;"</#if> id="people_destroyFriendship" />
                  </div>
    </#if>
  </#if>
  <#if status?has_content>
    <#assign url><@html.rewrite page="/${user.foreignKey}/statuses/${status.statusId}" /></#assign>
                  <p class="desc" style="font-size: 2.32em; line-height: 1.2em;">
                    <span id="people_status_${status.statusId}">
                      <@common.autoFormat data=status.body url=url />
                    </span>
                  </p>
                  <p>
                    <span class="meta" style="font-size: 1.08em; line-height: 2.2em;">
                      <a href="${url}">
    <@common.dateFormat date=status.sentTime format="dateTime.compact.variable" />
                      </a>
                      &nbsp;from&nbsp;<@macro.sourceWithLink source=status.source dedicatedClient=status.dedicatedClient />&nbsp;
    <#if status.referenceId &gt; 0>
      <#assign referenceSender=status.referenceSender?default("") />
                      <a href="<@html.rewrite page="/${referenceSender.foreignKey}/statuses/${status.referenceId}" />">
                        in reply to ${referenceSender.foreignKey}
                      </a>
    </#if>
                    </span>
    <#if login?has_content && login == user.foreignKey>
                    <span class="actions" style="float: right;">
      <#assign favorite=status.favorite?default("") />
                      <span id="people_favorite_${status.statusId}">
      <#if favorite?has_content>
                        <a href="#" onclick="return shovel.controller.unsetFavorite(${status.statusId});">
                          <img src="<@html.rewrite href="${webroot}/image/star_full.png" />" />
                        </a>
      <#else>
                        <a href="#" onclick="return shovel.controller.setFavorite(${status.statusId});">
                          <img src="<@html.rewrite href="${webroot}/image/star_empty.png" />" />
                        </a>
      </#if>
                      </span>
                      <a href="#" onclick="return shovel.controller.destroyStatus(${status.statusId});">
                        <img src="<@html.rewrite href="${webroot}/image/trash.png" />" />
                      </a>
                    </span>
    </#if>
                  </p>
  <#else>
                  <div style="margin-top: .7em;">
                    <p style="font-size: 1.9em;">
                      <em>まだ投稿がありません。</em>
                    </p>
                  </div>
  </#if>
                </div>
                <div id="people_timeline" class="yui-navset">
                  <ul class="yui-nav">
                    <li id="nav_user_timeline"<#if viewType.userTimeline> class="selected"</#if>><a href="<@html.rewrite page="/${user.foreignKey}" />"><em>このユーザーの</em></a></li>
                    <li id="nav_with_friends"<#if viewType.withFriends> class="selected"</#if>><a href="<@html.rewrite page="/${user.foreignKey}/with_friends" />"><em>このユーザー周辺の</em></a></li>
                  </ul>
                  <div class="yui-content">
                    <div id="user_timeline"><#if viewType.userTimeline><#include "people/content.ftl" /></#if></div>
                    <div id="with_friends"><#if viewType.withFriends><#include "home/content.ftl" /></#if></div>
                  </div>
</#if>
                </div>
              </div>
            </form>
          </div>
<#include "footer.ftl" />
        </div>
      </div>
      <div class="sidebar-wrapper">
        <div class="sidebar" id="people_sidebar">
<#include "people/sidebar.ftl" />
        </div>
        <div style="height: 10px;"></div>
      </div>
    </div>
<#include "template.ftl" />
  </body>
</html>
