/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public enum ViewType {
    ARCHIVE("archive"),
    FAVORITES("favorites"),
    PREVIOUS("previous"),
    PUBLIC_TIMELINE("public_timeline"),
    RECENT("recent"),
    REPLIES("replies"),
    WITH_FRIENDS("with_friends"),
    INBOX("inbox"),
    SENT("sent"),
    SEARCH_USERS("searchUsers"),
    FRIENDS_TIMELINE("friends_timeline"),
    USER_TIMELINE("user_timeline"),
    FRIENDS("friends"),
    FOLLOWERS("followers"),
    FRIEND_REQUESTS("friend_requests"),
    ACCOUNTS("accounts");

    String id_;

    private ViewType(String id) {
        this.id_ = id;
    }

    public String getId() {
        return this.id_;
    }

    public static ViewType find(String id) {
        id = id.toLowerCase();
        for (ViewType type : ViewType.values()) {
            if (id.compareTo(type.getId()) != 0) continue;
            return type;
        }
        return RECENT;
    }

    public boolean isArchive() {
        return this == ARCHIVE;
    }

    public boolean isFavorites() {
        return this == FAVORITES;
    }

    public boolean isPrevious() {
        return this == PREVIOUS;
    }

    public boolean isPublicTimeline() {
        return this == PUBLIC_TIMELINE;
    }

    public boolean isRecent() {
        return this == RECENT;
    }

    public boolean isReplies() {
        return this == REPLIES;
    }

    public boolean isWithFriends() {
        return this == WITH_FRIENDS;
    }

    public boolean isInbox() {
        return this == INBOX;
    }

    public boolean isSent() {
        return this == SENT;
    }

    public boolean isFriendsTimeline() {
        return this == FRIENDS_TIMELINE;
    }

    public boolean isUserTimeline() {
        return this == USER_TIMELINE;
    }

    public boolean isFriends() {
        return this == FRIENDS;
    }

    public boolean isFollowers() {
        return this == FOLLOWERS;
    }

    public boolean isFriendRequests() {
        return this == FRIEND_REQUESTS;
    }

    public boolean isAccounts() {
        return this == ACCOUNTS;
    }

    public boolean isSearchUsers() {
        return this == SEARCH_USERS;
    }
}

