/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.IFavoritesAction;
import jp.sourceforge.shovel.action.impl.FavoritesActionImpl;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IStatusesForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.seasar.framework.container.S2Container;

public class FavoritesActionImpl
implements IFavoritesAction {
    IStatusesForm actionForm_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    HttpSession session_;
    S2Container container_;

    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        IUser user;
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        String foreignKey = this.actionForm_.getForeignKey();
        boolean home = true;
        if (foreignKey == null || foreignKey.length() <= 0) {
            user = directoryService.getLoginUser();
        } else {
            user = directoryService.getUser(foreignKey);
            home = false;
        }
        if (user == null) {
            throw new ApplicationException("");
        }
        FormatType formatType = this.actionForm_.getFormatType();
        boolean protect = false;
        if (!home && user.isProtect()) {
            IUser loginUser = directoryService.getLoginUser();
            protect = true;
            if (loginUser != null) {
                if (loginUser.getUserId() == user.getUserId()) {
                    protect = false;
                } else {
                    IFriendship[] friends;
                    for (IFriendship tmp : friends = shovelService.getRequests(user.getUserId())) {
                        if (tmp.getRemovedTime() > 0L) continue;
                        if (tmp.getPassiveId() == user.getUserId()) {
                            protect &= !tmp.isAccept();
                            this.request_.setAttribute("friend", (Object)tmp);
                            continue;
                        }
                        protect &= false;
                        this.request_.setAttribute("follower", (Object)tmp);
                    }
                }
            }
        }
        IStatus[] temp = null;
        IStatus[] statuses = new IStatus[]{};
        IListRefine listRefine = (IListRefine)this.session_.getAttribute("listRefine");
        if (listRefine == null || !listRefine.getViewType().isFavorites()) {
            listRefine = (IListRefine)this.container_.getComponent(IListRefine.class);
            this.session_.setAttribute("listRefine", (Object)listRefine);
        } else if (this.actionForm_.getMethodType().isPage()) {
            listRefine.setPage(this.actionForm_.getPage());
        }
        listRefine.setViewType(ViewType.FAVORITES);
        if (!protect) {
            int page = this.actionForm_.getPage();
            int limit = this.actionForm_.getCount();
            if (formatType.isHtml()) {
                page = listRefine.getPage();
                limit = 0;
            }
            temp = shovelService.getFavorites(user.getForeignKey(), page, limit);
            statuses = shovelService.prepareForView(temp, limit, true);
        }
        this.request_.setAttribute("protect", (Object)protect);
        String forward = null;
        switch (1.$SwitchMap$jp$sourceforge$shovel$FormatType[formatType.ordinal()]) {
            case 1: {
                shovelService.prepareForView(user);
                this.request_.setAttribute("user", (Object)user);
                IFriendship[] friendships = shovelService.getFriends(user.getForeignKey(), 0, 100);
                this.request_.setAttribute("viewAllFriends", (Object)(friendships.length > 100 ? 1 : 0));
                friendships = shovelService.prepareForView(friendships, 100, true);
                this.request_.setAttribute("friendships", (Object)friendships);
                if (!protect) {
                    boolean nextPage = false;
                    if (statuses != null) {
                        nextPage = temp.length > statuses.length;
                    }
                    this.request_.setAttribute("nextPage", (Object)nextPage);
                }
                forward = this.actionForm_.isPartial() ? "partial" : "full";
                break;
            }
            case 2: 
            case 3: {
                forward = formatType.getId();
                break;
            }
            case 4: 
            case 5: {
                shovelService.outputFeed(formatType, ViewType.FAVORITES, user, statuses);
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        this.request_.setAttribute("statuses", (Object)statuses);
        return forward;
    }

    public void setStatusesForm(IStatusesForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response_ = response;
    }

    public void setSession(HttpSession session) {
        this.session_ = session;
    }
}

