/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.action.ILoginAction;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.form.ILoginForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.util.HttpUtil;

public class LoginActionImpl
implements ILoginAction {
    ILoginForm actionForm_;
    IDirectoryService directoryService_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    HttpSession session_;

    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        String url;
        IUser user = this.directoryService_.login(this.actionForm_.getAccount(), this.actionForm_.getPassword(), false);
        if (user == null) {
            this.session_.setAttribute("errorCode", (Object)"LOGIN00000");
            this.session_.setAttribute("actionForm", (Object)this.actionForm_);
            url = "/";
        } else {
            Cookie cookie = new Cookie("ShovelAccount", this.actionForm_.getAccount());
            cookie.setPath("/");
            if (this.actionForm_.isSaveAccount()) {
                cookie.setMaxAge(604800);
            } else {
                cookie.setMaxAge(0);
            }
            this.response_.addCookie(cookie);
            url = (String)this.session_.getAttribute("loginRedirectUrl");
            if (url == null) {
                url = "/public_timeline";
            }
        }
        HttpUtil.sendRedirect((HttpServletResponse)this.response_, (String)url);
        return null;
    }

    public void setDirectoryService(IDirectoryService directoryService) {
        this.directoryService_ = directoryService;
    }

    public void setLoginForm(ILoginForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response_ = response;
    }

    public void setSession(HttpSession session) {
        this.session_ = session;
    }
}

