/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.SystemConfigType;
import jp.sourceforge.shovel.ViewType;
import jp.sourceforge.shovel.action.ISystemAction;
import jp.sourceforge.shovel.action.impl.SystemActionImpl;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IListRefine;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.ISystemForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import org.seasar.framework.container.S2Container;

public class SystemActionImpl
implements ISystemAction {
    ISystemForm actionForm_;
    S2Container container_;
    HttpServletRequest request_;
    HttpSession session_;

    @Perform(CSRF=false, administrator=true)
    public String perform() throws Exception {
        IListRefine listRefine = (IListRefine)this.session_.getAttribute("listRefine");
        if (listRefine == null || !listRefine.getViewType().isAccounts()) {
            listRefine = (IListRefine)this.container_.getComponent(IListRefine.class);
            this.session_.setAttribute("listRefine", (Object)listRefine);
        } else if (this.actionForm_.getMethodType().isPage()) {
            listRefine.setPage(this.actionForm_.getPage());
        } else if (this.actionForm_.getMethodType().isSortOrder()) {
            listRefine.setSortOrder(this.actionForm_.getSortOrder());
            listRefine.setPage(0);
        }
        listRefine.setViewType(ViewType.ACCOUNTS);
        SystemConfigType configType = this.actionForm_.getConfigType();
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser user = null;
        switch (1.$SwitchMap$jp$sourceforge$shovel$SystemConfigType[configType.ordinal()]) {
            case 1: {
                SortOrderType sortOrderType = listRefine.getSortOrderType();
                int page = listRefine.getPage();
                IUser[] users = directoryService.getUsers(SortType.USER_ID, sortOrderType, page);
                if (users != null && users.length > 0) {
                    IUser[] tmp = shovelService.prepareForView(users, 0);
                    this.request_.setAttribute("nextPage", (Object)(users.length > tmp.length ? 1 : 0));
                    users = tmp;
                }
                this.request_.setAttribute("users", (Object)users);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                user = directoryService.getUser(this.actionForm_.getUserId());
            }
            case 4: {
                if (user == null) {
                    user = directoryService.createTemporaryUser();
                }
                shovelService.prepareForView(new IUser[]{user}, 1);
                String[] timeZoneIDs = TimeZone.getAvailableIDs();
                TimeZone[] timeZones = new TimeZone[timeZoneIDs.length];
                int i = 0;
                for (String timeZoneID : timeZoneIDs) {
                    timeZones[i++] = TimeZone.getTimeZone(timeZoneID);
                }
                Properties props = (Properties)this.container_.getComponent((Object)"commonProperties");
                String maxSize = props.getProperty("upload.maxSize");
                this.request_.setAttribute("maxSize", (Object)Integer.parseInt(maxSize));
                this.request_.setAttribute("user", (Object)user);
                this.request_.setAttribute("defaultTimeZone", (Object)TimeZone.getDefault());
                this.request_.setAttribute("timeZones", (Object)timeZones);
                this.request_.setAttribute("domain", (Object)this.request_.getServerName());
                this.request_.setAttribute("port", (Object)this.request_.getServerPort());
                break;
            }
            default: {
                throw new ApplicationException("");
            }
        }
        this.request_.setAttribute("config", (Object)configType);
        return this.actionForm_.isPartial() ? configType.getForward() : "system";
    }

    public void setSystemForm(ISystemForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setSession(HttpSession session) {
        this.session_ = session;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }
}

