/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.dao.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import jp.sourceforge.shovel.dao.IUserCustomDao;
import jp.sourceforge.shovel.entity.IUser;
import org.apache.commons.lang.ArrayUtils;
import org.seasar.dao.DaoMetaDataFactory;
import org.seasar.dao.impl.AbstractDao;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserCustomDaoImpl
extends AbstractDao
implements IUserCustomDao {
    public UserCustomDaoImpl(DaoMetaDataFactory daoMetaDataFactory) {
        super(daoMetaDataFactory);
    }

    String escape(String param) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < param.length(); ++i) {
            String ch = param.substring(i, i + 1);
            if (ch.compareTo("%") == 0 || ch.compareTo("_") == 0) {
                escaped.append("\\");
            }
            escaped.append(ch);
        }
        return escaped.toString();
    }

    void execPartialSQL(Map<Long, IUser> userMap, String column, String[] keywords, int offset, int limit) {
        IUser[] users;
        StringBuilder sqlBuilder = new StringBuilder();
        ArrayList<Object> argList = new ArrayList<Object>();
        sqlBuilder.append("SELECT\n");
        sqlBuilder.append("    a.*,\n");
        sqlBuilder.append("    b.serverFileId,\n");
        sqlBuilder.append("    b.name,\n");
        sqlBuilder.append("    b.mime,\n");
        sqlBuilder.append("    b.size,\n");
        sqlBuilder.append("    b.charset,\n");
        sqlBuilder.append("    b.width,\n");
        sqlBuilder.append("    b.height,\n");
        sqlBuilder.append("    b.createdTime AS serverFileCreatedTime,\n");
        sqlBuilder.append("    c.*\n");
        sqlBuilder.append("FROM\n");
        sqlBuilder.append("    (users AS a LEFT JOIN\n");
        sqlBuilder.append("     serverfiles AS b ON a.profileImageId=b.serverFileId) LEFT JOIN\n");
        sqlBuilder.append("     devices AS c ON a.userId=c.userId\n");
        sqlBuilder.append("WHERE\n");
        sqlBuilder.append("    a.remove=false AND\n");
        for (int i = 0; i < keywords.length; ++i) {
            sqlBuilder.append("    ");
            sqlBuilder.append(column);
            sqlBuilder.append(" LIKE ?");
            if (i + 1 < keywords.length) {
                sqlBuilder.append("AND");
            }
            sqlBuilder.append("\n");
            keywords[i] = this.escape(keywords[i]);
            argList.add("%" + keywords[i] + "%");
        }
        sqlBuilder.append("ORDER BY\n");
        sqlBuilder.append("    a.userId DESC\n");
        sqlBuilder.append("LIMIT ?,?");
        argList.add(offset);
        argList.add(limit);
        Object[] args = argList.toArray(new Object[argList.size()]);
        for (IUser user : users = (IUser[])this.getEntityManager().findArray(sqlBuilder.toString(), args)) {
            userMap.put(user.getUserId(), user);
        }
    }

    public IUser[] search(String[] keywords, int offset, int limit) {
        HashMap userMap = new HashMap();
        this.execPartialSQL(userMap, "a.displayName", keywords, offset, limit);
        this.execPartialSQL(userMap, "a.foreignKey", keywords, offset, limit);
        this.execPartialSQL(userMap, "a.location", keywords, offset, limit);
        Collection userCollection = userMap.values();
        Object[] users = userCollection.toArray(new IUser[userCollection.size()]);
        return (IUser[])ArrayUtils.subarray((Object[])users, (int)0, (int)limit);
    }
}

