/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.device.impl;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import jp.sourceforge.shovel.AvailabilityType;
import jp.sourceforge.shovel.ServicePropertyType;
import jp.sourceforge.shovel.device.IMsnpWrapper;
import jp.sourceforge.shovel.device.impl.AbstractDeviceWrapperImpl;
import jp.sourceforge.shovel.device.impl.MsnpWrapperImpl;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import net.sf.jml.Email;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnGroup;
import net.sf.jml.MsnMessenger;
import net.sf.jml.MsnSwitchboard;
import net.sf.jml.event.MsnContactListListener;
import net.sf.jml.event.MsnMessageListener;
import net.sf.jml.event.MsnMessengerListener;
import net.sf.jml.impl.MsnMessengerFactory;
import net.sf.jml.message.MsnControlMessage;
import net.sf.jml.message.MsnDatacastMessage;
import net.sf.jml.message.MsnInstantMessage;
import net.sf.jml.message.MsnSystemMessage;
import net.sf.jml.message.MsnUnknownMessage;
import net.sf.jml.message.p2p.MsnP2PMessage;

public class MsnpWrapperImpl
extends AbstractDeviceWrapperImpl
implements IMsnpWrapper {
    String displayName_;
    String email_;
    String password_;
    MsnMessenger messenger_;
    boolean login_;
    BlockingQueue<Object> queue_;

    public String getDisplayName() {
        return this.displayName_;
    }

    public void setDisplayName(String displayName) {
        this.displayName_ = displayName;
    }

    public String getEmail() {
        return this.email_;
    }

    public void setEmail(String email) {
        this.email_ = email;
    }

    public String getPassword() {
        return this.password_;
    }

    public void setPassword(String password) {
        this.password_ = password;
    }

    public String getDeviceType() {
        return "msnp";
    }

    public String getAddress() {
        return this.getEmail();
    }

    public boolean isSettings() {
        return true;
    }

    public void setProperty(String key, String value) {
        switch (1.$SwitchMap$jp$sourceforge$shovel$ServicePropertyType[ServicePropertyType.find((String)key).ordinal()]) {
            case 1: {
                this.setDisplayName(value);
                break;
            }
            case 2: {
                this.setEmail(value);
                break;
            }
            case 3: {
                this.setPassword(value);
                break;
            }
        }
    }

    public void login() throws ApplicationException {
        if (this.queue_ == null) {
            this.queue_ = new SynchronousQueue();
        }
        this.messenger_ = MsnMessengerFactory.createMsnMessenger((String)this.getEmail(), (String)this.getPassword());
        this.messenger_.setLogIncoming(true);
        this.messenger_.setLogOutgoing(true);
        this.messenger_.addContactListListener((MsnContactListListener)this);
        this.messenger_.addMessengerListener((MsnMessengerListener)this);
        this.messenger_.addMessageListener((MsnMessageListener)this);
        this.messenger_.login();
    }

    public void logout() {
        this.messenger_.logout();
    }

    public void sendMessage(IUser receiver, String body) {
        IDevice device = receiver.getDevice();
        if (this.getDeviceType().compareToIgnoreCase(device.getType()) == 0 && device.getAvailabilityType() == AvailabilityType.ON) {
            String address = receiver.getAddress();
            if (address == null || address.length() <= 0) {
                return;
            }
            Email email = Email.parseStr((String)address);
            this.messenger_.sendText(email, body);
        }
    }

    public void pushMessage(IStatus status) throws ApplicationException {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.queue_.put(status);
        }
        catch (InterruptedException e) {
            throw new ApplicationException("");
        }
    }

    public boolean isConnected() {
        return this.messenger_ != null && this.login_;
    }

    public void dispatch() throws ApplicationException {
        if (!this.isConnected()) {
            return;
        }
        try {
            Object o = this.queue_.take();
            this.sendMessage((IStatus)o);
        }
        catch (InterruptedException e) {
            throw new ApplicationException("");
        }
    }

    public void contactAddedMe(MsnMessenger messenger, MsnContact contact) {
    }

    public void contactListSyncCompleted(MsnMessenger messenger) {
    }

    public void contactListInitCompleted(MsnMessenger messenger) {
    }

    public void contactStatusChanged(MsnMessenger messenger, MsnContact contact) {
    }

    public void ownerStatusChanged(MsnMessenger messenger) {
    }

    public void contactRemovedMe(MsnMessenger messenger, MsnContact contact) {
    }

    public void contactAddCompleted(MsnMessenger messenger, MsnContact contact) {
    }

    public void contactRemoveCompleted(MsnMessenger messenger, MsnContact contact) {
    }

    public void groupAddCompleted(MsnMessenger messenger, MsnGroup group) {
    }

    public void groupRemoveCompleted(MsnMessenger messenger, MsnGroup group) {
    }

    public void loginCompleted(MsnMessenger messenger) {
        this.login_ = true;
    }

    public void logout(MsnMessenger messenger) {
        this.login_ = false;
        this.messenger_ = null;
    }

    public void exceptionCaught(MsnMessenger messenger, Throwable throwable) {
    }

    public void instantMessageReceived(MsnSwitchboard switchboard, MsnInstantMessage message, MsnContact contact) {
        try {
            String address = contact.getEmail().getEmailAddress();
            String body = message.getContent();
            this.receiveMessage(address, body);
        }
        catch (ApplicationException e) {
            // empty catch block
        }
    }

    public void controlMessageReceived(MsnSwitchboard switchboard, MsnControlMessage message, MsnContact contact) {
    }

    public void systemMessageReceived(MsnMessenger messenger, MsnSystemMessage message) {
    }

    public void datacastMessageReceived(MsnSwitchboard switchboard, MsnDatacastMessage message, MsnContact contact) {
    }

    public void unknownMessageReceived(MsnSwitchboard switchboard, MsnUnknownMessage message, MsnContact contact) {
    }

    public void p2pMessageReceived(MsnSwitchboard switchboard, MsnP2PMessage message, MsnContact contact) {
    }
}

