/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.interceptor;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.ErrorPageType;
import jp.sourceforge.shovel.FormatType;
import jp.sourceforge.shovel.ThumbnailType;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.device.IAbstractDeviceWrapper;
import jp.sourceforge.shovel.entity.IDedicatedClient;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import jp.sourceforge.shovel.util.HttpUtil;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.codec.binary.Base64;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.container.S2Container;

public class AuthenticateInterceptor
extends AbstractInterceptor {
    static final long serialVersionUID = 1L;
    S2Container container_;

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    S2Container getContainer() {
        return this.container_;
    }

    HttpServletRequest getRequest() {
        return (HttpServletRequest)this.getContainer().getComponent((Object)"request");
    }

    HttpServletResponse getResponse() {
        return (HttpServletResponse)this.getContainer().getComponent((Object)"response");
    }

    HttpSession getSession() {
        return (HttpSession)this.getContainer().getComponent((Object)"session");
    }

    ServletContext getApplication() {
        return (ServletContext)this.getContainer().getComponent((Object)"application");
    }

    IShovelService getShovelService() {
        HttpServletRequest request = this.getRequest();
        IShovelService shovelService = (IShovelService)request.getAttribute("shovelService");
        if (shovelService == null) {
            shovelService = (IShovelService)this.getContainer().getComponent(IShovelService.class);
            request.setAttribute("shovelService", (Object)shovelService);
        }
        return shovelService;
    }

    IDirectoryService getDirectoryService() {
        return this.getShovelService().getDirectoryService();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String format;
        String parameter;
        String header;
        HttpServletRequest request = this.getRequest();
        HttpServletResponse response = this.getResponse();
        HttpSession session = this.getSession();
        ServletContext context = this.getApplication();
        Perform annotation = invocation.getMethod().getAnnotation(Perform.class);
        ErrorPageType errorPageType = ErrorPageType.HTML;
        boolean login = true;
        boolean administrator = false;
        if (annotation != null) {
            login = annotation.login();
            administrator = annotation.administrator();
        }
        login |= request.getAttribute("requireLogin") != null;
        request.removeAttribute("requireLogin");
        FormatType formatType = FormatType.find((String)request.getParameter("format"));
        if (!formatType.isHtml()) {
            errorPageType = ErrorPageType.find((String)formatType.getId());
            request.setAttribute("mimeType", (Object)formatType.getMimeType());
        }
        if ((header = request.getHeader("X-Requested-With")) != null && header.compareToIgnoreCase("XMLHttpRequest") == 0) {
            errorPageType = ErrorPageType.XHR;
        }
        if ((parameter = request.getParameter("iframe")) != null) {
            errorPageType = ErrorPageType.IFRAME;
        }
        if (context.getAttribute("thumbnail") == null) {
            Properties props = (Properties)this.getContainer().getComponent((Object)"commonProperties");
            String type = props.getProperty("thumbnail.creator");
            ThumbnailType thumbnailType = ThumbnailType.find((String)type);
            if (thumbnailType.isImageMagick()) {
                String bindir = props.getProperty("thumbnail.image_magick.bin");
                boolean image_magick = false;
                if (bindir != null) {
                    File file = new File(bindir);
                    image_magick = file.exists();
                }
                if (!image_magick) {
                    thumbnailType = ThumbnailType.SHOVEL;
                }
            }
            context.setAttribute("thumbnail", (Object)thumbnailType);
        }
        if (context.getAttribute("device") == null) {
            IAbstractDeviceWrapper[] messengers = this.getShovelService().getMessengerWrappers();
            boolean device = false;
            ArrayList<IAbstractDeviceWrapper> messengerList = new ArrayList<IAbstractDeviceWrapper>();
            for (IAbstractDeviceWrapper messenger : messengers) {
                if (!messenger.isSettings()) {
                    context.setAttribute(messenger.getDeviceType(), (Object)true);
                    continue;
                }
                messengerList.add(messenger);
                device |= messenger.isConnected();
            }
            context.setAttribute("messengers", (Object)messengers);
            context.setAttribute("device", (Object)device);
        }
        if ((format = request.getParameter("format")) != null && format.length() > 0) {
            errorPageType = ErrorPageType.XML;
        } else {
            ErrorPageType forward = (ErrorPageType)request.getAttribute("errorPageType");
            if (forward != null) {
                errorPageType = forward;
            }
        }
        request.setAttribute("errorPageType", (Object)errorPageType);
        IUser user = null;
        if (request.getAttribute("basicAuthentication") != null) {
            header = request.getHeader("Authorization");
            if (header != null && header.length() > 0) {
                String foreignKey;
                int i = header.indexOf("Basic");
                String base64 = header.substring(i + 6);
                byte[] authInfo = Base64.decodeBase64((byte[])base64.getBytes("UTF-8"));
                String auth = new String(authInfo, "UTF-8");
                String[] tokens = auth.split(":");
                String password = null;
                switch (tokens.length) {
                    case 2: {
                        password = tokens[1];
                    }
                    case 1: {
                        foreignKey = tokens[0];
                        break;
                    }
                    default: {
                        throw new ApplicationException("");
                    }
                }
                user = this.getDirectoryService().login(foreignKey, password, true);
            }
            if (user == null) {
                response.addHeader("WWW-Authenticate", "Basic realm=\"Shovel API\"");
                response.setStatus(401);
                session.removeAttribute("loginRedirectUrl");
                throw new ApplicationException("");
            }
        }
        user = this.getDirectoryService().getLoginUser();
        header = request.getHeader("X-Twitter-Client");
        if (header != null && header.length() > 0) {
            String key = header;
            String url = request.getHeader("X-Twitter-Client-URL");
            String version = request.getHeader("X-Twitter-Client-Version");
            IDedicatedClient client = this.getShovelService().getClient(key);
            if (client == null) {
                this.getShovelService().createClient(key, url, version);
            } else if (version != null && client.getVersion() != null) {
                try {
                    if (Float.parseFloat(version) > Float.parseFloat(client.getVersion())) {
                        client.setVersion(version);
                        client.setUrl(url);
                        this.getShovelService().updateClient(client);
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        if (request.getParameter("logout") != null && session.getAttribute("logout") == null) {
            session.setAttribute("logout", (Object)true);
            login = true;
            user = null;
        }
        if (user != null && !user.isAdministrator() && administrator) {
            throw new ApplicationException("");
        }
        if (login && user == null) {
            String path = request.getRequestURI();
            HashMap parameterMap = new HashMap();
            parameterMap.putAll(request.getParameterMap());
            parameterMap.remove("logout");
            path = HttpUtil.toRequestFullPath((String)path, parameterMap);
            path = path.substring(request.getContextPath().length());
            RequestDispatcher rd = request.getRequestDispatcher("/root.do");
            response.setHeader("X-Login", "1");
            rd.forward((ServletRequest)request, (ServletResponse)response);
            return null;
        }
        return invocation.proceed();
    }
}

