/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.interceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.entity.TokenProcessorWrapper;
import jp.sourceforge.shovel.exception.ApplicationRuntimeException;
import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.AbstractInterceptor;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.annotation.tiger.Binding;
import org.seasar.framework.container.annotation.tiger.BindingType;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CsrfInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = 1L;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.isCsrf(invocation)) {
            this.checkCSRF();
        }
        return invocation.proceed();
    }

    boolean isCsrf(MethodInvocation invocation) {
        Perform annotation = invocation.getMethod().getAnnotation(Perform.class);
        return annotation == null ? true : annotation.CSRF();
    }

    void checkCSRF() {
        String token1 = CsrfInterceptor.getRequest().getParameter("csrf_ticket");
        if (token1 == null) {
            throw new ApplicationRuntimeException("COMMON01000");
        }
        String token2 = (String)CsrfInterceptor.getSession().getAttribute("csrf_ticket");
        if (!token1.equals(token2)) {
            throw new ApplicationRuntimeException("COMMON01001");
        }
    }

    @Binding(bindingType=BindingType.NONE)
    public static void setCsrfTicket(IUser user) {
        String userId = String.valueOf(user.getUserId());
        String ticket = CsrfInterceptor.getTokenProcessor().generateToken(userId);
        CsrfInterceptor.getSession().setAttribute("csrf_ticket", (Object)ticket);
    }

    static S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }

    static HttpServletRequest getRequest() {
        return (HttpServletRequest)CsrfInterceptor.getContainer().getComponent((Object)"request");
    }

    static HttpSession getSession() {
        return (HttpSession)CsrfInterceptor.getContainer().getComponent((Object)"session");
    }

    static TokenProcessorWrapper getTokenProcessor() {
        return new TokenProcessorWrapper();
    }
}

