/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.interceptor;

import freemarker.template.TemplateException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sourceforge.shovel.ErrorPageType;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.exception.ApplicationRuntimeException;
import jp.sourceforge.shovel.exception.ErrorPage;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.struts.util.MessageResources;
import org.seasar.framework.aop.interceptors.ThrowsInterceptor;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.exception.SQLRuntimeException;
import org.seasar.framework.exception.SSQLException;

public class HandleThrowableInterceptor
extends ThrowsInterceptor {
    static final long serialVersionUID = -1L;
    static final ErrorPageType DEFAULT_ERROR_PAGE = ErrorPageType.HTML;
    S2Container container_;

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    S2Container getContainer() {
        return this.container_;
    }

    private ErrorPage createErrorPage(Throwable cause, MethodInvocation invocation) {
        HttpServletRequest request = (HttpServletRequest)invocation.getArguments()[0];
        HttpServletResponse response = (HttpServletResponse)invocation.getArguments()[1];
        request.setAttribute("exceptionKey", (Object)"org.apache.struts.action.EXCEPTION");
        ErrorPageType errorPageType = (ErrorPageType)request.getAttribute("errorPageType");
        if (errorPageType == null) {
            errorPageType = DEFAULT_ERROR_PAGE;
        }
        StringBuilder component = new StringBuilder(errorPageType.getKey());
        component.append("ErrorPage");
        ErrorPage errorPage = (ErrorPage)((Object)this.getContainer().getComponent((Object)component.toString()));
        errorPage.setRequest(request);
        errorPage.setResponse(response);
        errorPage.initCause(cause);
        request.setAttribute("charset", (Object)"UTF-8");
        request.setAttribute("org.apache.struts.action.EXCEPTION", (Object)errorPage);
        return errorPage;
    }

    public void handleThrowable(ServletException exception, MethodInvocation invocation) throws ErrorPage {
        Throwable rootCause = exception.getRootCause();
        Throwable cause = rootCause.getCause();
        if (rootCause.getStackTrace().length > 1024) {
            return;
        }
        if (cause instanceof ApplicationException) {
            this.handleThrowable((ApplicationException)cause, invocation);
        } else if (rootCause instanceof ApplicationRuntimeException) {
            this.handleThrowable((ApplicationRuntimeException)rootCause, invocation);
        } else if (rootCause instanceof TemplateException) {
            this.handleThrowable((TemplateException)rootCause, invocation);
        } else if (rootCause instanceof SQLRuntimeException) {
            this.handleThrowable((SQLRuntimeException)rootCause, invocation);
        } else {
            this.handleThrowable((Exception)rootCause, invocation);
        }
    }

    public void handleThrowable(ApplicationException cause, MethodInvocation invocation) throws ErrorPage {
        ErrorPage ep = this.createErrorPage((Throwable)cause, invocation);
        ep.setErrorCode(cause.getBundle(), cause.getKey());
        ep.setOutputErrorCode(cause.getOutputErrorCode());
        ep.setCauseArgs(cause.getCauseArgs());
        ep.setCounterMeasureArgs(cause.getCounterMeasureArgs());
        ep.setDeveloperInfoArgs(cause.getDeveloperInfoArgs());
        ep.setDiagnosisArgs(cause.getDiagnosisArgs());
        throw ep;
    }

    public void handleThrowable(ApplicationRuntimeException cause, MethodInvocation invocation) throws ErrorPage {
        ErrorPage ep = this.createErrorPage((Throwable)cause, invocation);
        ep.setErrorCode(cause.getBundle(), cause.getKey());
        ep.setOutputErrorCode(cause.getOutputErrorCode());
        ep.setCauseArgs(cause.getCauseArgs());
        ep.setCounterMeasureArgs(cause.getCounterMeasureArgs());
        ep.setDeveloperInfoArgs(cause.getDeveloperInfoArgs());
        ep.setDiagnosisArgs(cause.getDiagnosisArgs());
        throw ep;
    }

    String escapeTemplate(String text) {
        StringBuilder buf = new StringBuilder("");
        Matcher matcher = Pattern.compile("\\{([^}]+)\\}").matcher(text);
        int i = 0;
        while (matcher.find()) {
            buf.append(text.substring(i, matcher.start(1) - 1));
            buf.append("&#123");
            buf.append(matcher.group(1));
            buf.append("&#125");
            i = matcher.end() + 1;
        }
        if (text.length() > i) {
            buf.append(text.substring(i));
        }
        return buf.toString();
    }

    public void handleThrowable(TemplateException cause, MethodInvocation invocation) throws ErrorPage {
        ErrorPage ep = this.createErrorPage((Throwable)cause, invocation);
        ep.setErrorCode("app", 101);
        String msg = this.escapeTemplate(cause.getMessage());
        ep.setCauseArgs(msg.replaceAll("\r?\n", "<br />"));
        msg = this.escapeTemplate(cause.getFTLInstructionStack());
        ep.setDeveloperInfoArgs(msg.replaceAll("\r?\n", "<br />"));
        throw ep;
    }

    public void handleThrowable(SQLRuntimeException cause, MethodInvocation invocation) throws ErrorPage {
        Class<?>[] classes;
        MessageResources resources = MessageResources.getMessageResources((String)"jp.sourceforge.shovel.error.db");
        for (Class<?> clazz : classes = cause.getCause().getClass().getClasses()) {
            if (clazz.getName().compareToIgnoreCase("SSQLException") != 0) continue;
            SSQLException sqlex = (SSQLException)cause.getCause();
            String message = resources.getMessage(String.format("%05d.diagnosis", sqlex.getErrorCode()));
            int errorCode = sqlex.getErrorCode();
            if (message == null) {
                errorCode = 99999;
            }
            ErrorPage ep = this.createErrorPage((Throwable)cause, invocation);
            ep.setErrorCode("db", errorCode);
            Throwable t = sqlex.getCause();
            ep.setCauseArgs(sqlex.getSQLState(), t.getMessage(), String.valueOf(sqlex.getErrorCode()));
            ep.setDeveloperInfoArgs(sqlex.getSql());
            throw ep;
        }
        ErrorPage ep = this.createErrorPage((Throwable)cause, invocation);
        ep.setErrorCode("app", 0);
        ep.setCauseArgs(cause.getSimpleMessage());
        throw ep;
    }

    public void handleThrowable(Exception cause, MethodInvocation invocation) throws ErrorPage {
        ErrorPage ep = this.createErrorPage((Throwable)cause, invocation);
        ep.setErrorCode("app", 0);
        ep.setCauseArgs(cause.getMessage());
        throw ep;
    }
}

