/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.logic.impl;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.StatusType;
import jp.sourceforge.shovel.dao.IDedicatedClientDao;
import jp.sourceforge.shovel.dao.IDeviceDao;
import jp.sourceforge.shovel.dao.IDirectMessageDao;
import jp.sourceforge.shovel.dao.IFavoriteDao;
import jp.sourceforge.shovel.dao.IFriendshipDao;
import jp.sourceforge.shovel.dao.IStatusDao;
import jp.sourceforge.shovel.device.IAbstractDeviceWrapper;
import jp.sourceforge.shovel.entity.IDedicatedClient;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IDirectMessage;
import jp.sourceforge.shovel.entity.IFavorite;
import jp.sourceforge.shovel.entity.IFriendship;
import jp.sourceforge.shovel.entity.IStatus;
import jp.sourceforge.shovel.entity.IStatusWrapper;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.logic.IShovelLogic;
import jp.sourceforge.shovel.logic.impl.ShovelLogicImpl;
import org.seasar.framework.container.S2Container;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ShovelLogicImpl
implements IShovelLogic {
    Map<String, IDedicatedClient> clientMap_ = new HashMap();
    Map<String, IAbstractDeviceWrapper> messengerWrapperMap_;
    S2Container container_;

    SortedMap<Long, StatusToken> parseStatus(String data, int type, String pattern, SortedMap<Long, StatusToken> tokenMap) {
        if (tokenMap == null) {
            tokenMap = new TreeMap<Long, StatusToken>();
        }
        Matcher matcher = Pattern.compile(pattern).matcher(data);
        while (matcher.find()) {
            StatusToken token = new StatusToken(this);
            token.setType(type);
            token.setStart(matcher.start());
            token.setEnd(matcher.end());
            int groupCount = matcher.groupCount();
            ArrayList<String> regs = new ArrayList<String>();
            for (int i = 0; i <= groupCount; ++i) {
                regs.add(matcher.group(i));
            }
            token.setRegs(regs);
            tokenMap.put(Long.valueOf(matcher.start()), token);
        }
        return tokenMap;
    }

    public IStatusWrapper parseStatus(String status) {
        if (status != null && status.length() > 0) {
            TreeMap tokenMap = new TreeMap();
            for (StatusTokenType statusTokenType : StatusTokenType.values()) {
                int id = statusTokenType.getId();
                String pattern = statusTokenType.getPattern();
                this.parseStatus(status, id, pattern, tokenMap);
            }
            IStatusWrapper statusWrapper = (IStatusWrapper)this.getContainer().getComponent(IStatusWrapper.class);
            statusWrapper.setStatusType(StatusType.STATUS);
            StatusToken[] tokens = tokenMap.values().toArray(new StatusToken[tokenMap.size()]);
            if (tokens != null && tokens.length > 0) {
                block13: for (StatusToken token : tokens) {
                    switch (token.getType()) {
                        case 2: {
                            statusWrapper.setOpen(true);
                        }
                        case 1: {
                            statusWrapper.setForeignKey(tokens[0].getRegs()[1]);
                            continue block13;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            statusWrapper.setForeignKey(tokens[0].getRegs()[1]);
                            statusWrapper.setText(tokens[0].getRegs()[3]);
                            statusWrapper.setStatusType(StatusType.DIRECT_MESSAGE);
                            continue block13;
                        }
                        case 7: {
                            statusWrapper.setForeignKey(tokens[0].getRegs()[1]);
                            statusWrapper.setStatusType(StatusType.FAVORITE);
                            continue block13;
                        }
                        case 9: 
                        case 10: {
                            statusWrapper.setForeignKey(tokens[0].getRegs()[1]);
                            statusWrapper.setStatusType(StatusType.FOLLOW);
                            continue block13;
                        }
                        case 12: 
                        case 13: {
                            statusWrapper.setForeignKey(tokens[0].getRegs()[1]);
                            statusWrapper.setStatusType(StatusType.LEAVE);
                            continue block13;
                        }
                        case 8: {
                            statusWrapper.setForeignKey(tokens[0].getRegs()[1]);
                            statusWrapper.setStatusType(StatusType.NOTIFY_ON);
                            continue block13;
                        }
                        case 11: {
                            statusWrapper.setForeignKey(tokens[0].getRegs()[1]);
                            statusWrapper.setStatusType(StatusType.NOTIFY_OFF);
                            continue block13;
                        }
                        case 14: 
                        case 15: 
                        case 16: {
                            statusWrapper.setStatusType(StatusType.SLEEP);
                            continue block13;
                        }
                        case 17: 
                        case 18: {
                            statusWrapper.setStatusType(StatusType.WAKE);
                            continue block13;
                        }
                    }
                }
            }
            return statusWrapper;
        }
        return null;
    }

    long parseRFC2822DateTime(String since) throws ApplicationException {
        try {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH);
            Date date = format.parse(since);
            return date.getTime();
        }
        catch (ParseException e) {
            throw new ApplicationException("");
        }
    }

    public IStatus getStatus(long statusId) {
        return this.getStatusDao().find(statusId);
    }

    public IStatus getRecent(long userId) {
        return this.getStatusDao().findRecent(userId);
    }

    public IStatus[] getRecents(long[] userIds) {
        IStatus[] statuses = this.getStatusDao().findAllRecent(userIds, 0, userIds.length);
        if (statuses == null || statuses.length <= 0) {
            return statuses;
        }
        long[] statusIds = new long[statuses.length];
        int i = 0;
        for (IStatus status : statuses) {
            statusIds[i++] = status.getStatusId();
        }
        return this.getStatusDao().findAll(statusIds, SortType.STATUS_ID, SortOrderType.DESC, 0, statusIds.length);
    }

    public IStatus[] getFavorites(long userId, int page, int limit) {
        return this.getStatusDao().findAllFavorite(userId, page, limit);
    }

    public IStatus[] getStatuses(int offset, int limit) {
        return this.getStatusDao().findAll(null, SortType.STATUS_ID, SortOrderType.DESC, offset, limit);
    }

    public IStatus[] getStatuses(long sinceId, int limit) {
        return this.getStatusDao().findAllBySinceId(sinceId, limit);
    }

    public IStatus[] getStatuses(String since, boolean useRemoved, int limit) throws ApplicationException {
        long sinceTime = this.parseRFC2822DateTime(since);
        return this.getStatusDao().findAllBySinceTime(sinceTime, useRemoved, limit);
    }

    public IStatus[] getStatuses(SortType sortType, SortOrderType sortOrderType, int limit) {
        return this.getStatusDao().findAll(null, sortType, sortOrderType, 0, limit);
    }

    public IStatus[] getStatuses(long userId, boolean withFriends, RepliesType repliesType, int offset, int limit) {
        if (withFriends) {
            return this.getStatusDao().findAllWithFriends(userId, repliesType, offset, limit);
        }
        return this.getStatusDao().findAllSingle(userId, offset, limit);
    }

    public IStatus[] getStatuses(long userId, boolean withFriends, RepliesType repliesType, String since, int limit) throws ApplicationException {
        long sentTime = this.parseRFC2822DateTime(since);
        if (withFriends) {
            return this.getStatusDao().findAllWithFriendsSinceTime(userId, repliesType, sentTime, limit);
        }
        return this.getStatusDao().findAllSingleSinceTime(userId, sentTime, limit);
    }

    public IStatus[] getReplies(long userId, int offset, int limit) {
        return this.getStatusDao().findAllReply(userId, offset, limit);
    }

    public IStatus updateStatus(String body, String source, long referenceSenderId, boolean open, long senderId) throws ApplicationException {
        IStatus reference;
        if (senderId <= 0L) {
            throw new ApplicationException("");
        }
        if (body == null || body.length() <= 0) {
            throw new ApplicationException("");
        }
        if (source == null || source.length() <= 0) {
            source = "web";
        }
        long referenceId = 0L;
        if (referenceSenderId > 0L && (reference = this.getStatusDao().findRecent(referenceSenderId)) != null) {
            referenceId = reference.getStatusId();
        }
        body = body.replaceAll("\\r?\\n", "");
        long sentTime = Calendar.getInstance().getTimeInMillis();
        IStatus status = (IStatus)this.getContainer().getComponent(IStatus.class);
        status.setBody(body);
        status.setSource(source);
        status.setReferenceId(referenceId);
        status.setReferenceSenderId(referenceSenderId);
        status.setSenderId(senderId);
        status.setSentTime(sentTime);
        status.setOpen(open);
        this.getStatusDao().insert(status);
        for (IAbstractDeviceWrapper messengerWrapper : this.messengerWrapperMap_.values()) {
            messengerWrapper.pushMessage(status);
        }
        return status;
    }

    public void receiveStatus(String status, String source, long referenceSenderId, boolean open, long senderId) throws ApplicationException {
        this.updateStatus(status, source, referenceSenderId, open, senderId);
    }

    public int incrementGivenFavorites(long statusId) {
        return this.getStatusDao().updateIncrementGivenFavorites(statusId);
    }

    public int decrementGivenFavorites(long statusId) {
        return this.getStatusDao().updateDecrementGivenFavorites(statusId);
    }

    public int updateStatusRemove(long statusId) {
        long removedTime = Calendar.getInstance().getTimeInMillis();
        return this.getStatusDao().updateRemove(statusId, removedTime);
    }

    public int clearStatusReference(long referenceId) {
        return this.getStatusDao().updateReference(referenceId);
    }

    public int removeStatus() {
        return this.getStatusDao().delete();
    }

    public IDirectMessage getDirectMessage(long directMessageId) {
        return this.getDirectMessageDao().find(directMessageId);
    }

    public IDirectMessage[] getDirectMessages(long userId, boolean sent, int offset, int limit) {
        return this.getDirectMessageDao().findAll(userId, sent, offset, limit);
    }

    public IDirectMessage[] getDirectMessages(long userId, boolean sent, long sinceId, int limit) {
        return this.getDirectMessageDao().findAllSinceId(userId, sent, sinceId, limit);
    }

    public IDirectMessage[] getDirectMessages(long userId, boolean sent, String since, int limit) throws ApplicationException {
        long sentTime = this.parseRFC2822DateTime(since);
        return this.getDirectMessageDao().findAllSinceTime(userId, sent, sentTime, limit);
    }

    public IDirectMessage createDirectMessage(String text, String source, long senderId, long recipientId) throws ApplicationException {
        if (senderId <= 0L || recipientId <= 0L) {
            throw new ApplicationException("");
        }
        if (text == null || text.length() <= 0) {
            throw new ApplicationException("");
        }
        if (source == null || source.length() <= 0) {
            source = "web";
        }
        long sentTime = Calendar.getInstance().getTimeInMillis();
        IDirectMessage directMessage = (IDirectMessage)this.getContainer().getComponent(IDirectMessage.class);
        directMessage.setText(text);
        directMessage.setRecipientId(recipientId);
        directMessage.setSenderId(senderId);
        directMessage.setSentTime(sentTime);
        directMessage.setSource(source);
        this.getDirectMessageDao().insert(directMessage);
        return directMessage;
    }

    public int destroyDirectMessage(long directMessageId, boolean sent) {
        long removedTime = Calendar.getInstance().getTimeInMillis();
        return this.getDirectMessageDao().updateRemovedTime(directMessageId, sent, removedTime);
    }

    public IFriendship getFriendship(long activeId, long passiveId) {
        return this.getFriendshipDao().find(activeId, passiveId);
    }

    public IFriendship getFriendship(long activeId, String passiveId) {
        return this.getFriendshipDao().findByPassiveForeignKey(activeId, passiveId);
    }

    public IFriendship getFriendship(String activeId, long passiveId) {
        return this.getFriendshipDao().findByActiveForeignKey(activeId, passiveId);
    }

    public IFriendship[] getFriends(long activeId, int offset, int limit) {
        return this.getFriendshipDao().findAllFriends(activeId, offset, limit);
    }

    public IFriendship[] getFriends(long activeId, long[] passiveIds) {
        if (passiveIds == null || passiveIds.length <= 0) {
            return new IFriendship[0];
        }
        return this.getFriendshipDao().findAllFriendsBy(activeId, passiveIds, 0, passiveIds.length);
    }

    public IFriendship[] getFollowers(long passiveId, int offset, int limit) {
        return this.getFriendshipDao().findAllFollowers(passiveId, offset, limit);
    }

    public IFriendship[] getFollowers(long passiveId, String deviceType, int offset, int limit) {
        return this.getFriendshipDao().findAllFollowersByDevice(passiveId, deviceType, offset, limit);
    }

    public IFriendship[] getFollowers(long passiveId, long[] activeIds) {
        return this.getFriendshipDao().findAllFollowersBy(passiveId, activeIds, 0, activeIds.length);
    }

    public IFriendship[] getRequests(long activeId, long passiveId) {
        return this.getFriendshipDao().find2WayRequests(activeId, passiveId);
    }

    public IFriendship[] getRequests(String activeId, long passiveId) {
        return this.getFriendshipDao().find2WayRequestsByForeignKey(activeId, passiveId);
    }

    public IFriendship[] getRequests(long passiveId, int offset, int limit) {
        return this.getFriendshipDao().findAllRequests(passiveId, offset, limit);
    }

    public int countPublicFriends(long activeId) {
        return this.getFriendshipDao().countPublicFriends(activeId);
    }

    public int countProtectFriends(long activeId) {
        return this.getFriendshipDao().countProtectFriends(activeId);
    }

    public int countAllFollowers(long passiveId) {
        return this.getFriendshipDao().countAllFollowers(passiveId);
    }

    public int countAcceptFollowers(long passiveId) {
        return this.getFriendshipDao().countAcceptFollowers(passiveId);
    }

    public int countRequestFollowers(long activeId) {
        return this.getFriendshipDao().countRequestFollowers(activeId);
    }

    public IFriendship createFriendship(long activeId, long passiveId, boolean accept, long createdTime) throws ApplicationException {
        if (activeId == passiveId) {
            throw new ApplicationException("");
        }
        IFriendship friendship = (IFriendship)this.getContainer().getComponent(IFriendship.class);
        friendship.setAccept(accept);
        friendship.setActiveId(activeId);
        friendship.setCreatedTime(createdTime);
        friendship.setNotify(true);
        friendship.setPassiveId(passiveId);
        this.getFriendshipDao().insert(friendship);
        return friendship;
    }

    public int updateFriendship(IFriendship friendship) {
        return this.getFriendshipDao().update(friendship);
    }

    public int updateFriendships(long[] friendshipIds, boolean accept, long createdTime, boolean notify, long removedTime) {
        return this.getFriendshipDao().updateAll(friendshipIds, accept, createdTime, notify, removedTime);
    }

    public int updateFriendshipNotify(long activeId, long passiveId, boolean notify) {
        return this.getFriendshipDao().updateNotifyByUserId(activeId, passiveId, notify);
    }

    public int updateFriendshipNotify(long activeId, String passiveId, boolean notify) {
        return this.getFriendshipDao().updateNotifyByForeignKey(activeId, passiveId, notify);
    }

    public IFavorite getFavorite(long statusId, long userId) {
        return this.getFavoriteDao().findFavorite(statusId, userId);
    }

    public IFavorite[] getFavorites(long[] statusIds, long userId) {
        return this.getFavoriteDao().findAllFavorite(statusIds, userId, statusIds.length);
    }

    public IFavorite createFavorite(long statusId, long userId) {
        long createdTime = Calendar.getInstance().getTimeInMillis();
        IFavorite favorite = (IFavorite)this.getContainer().getComponent(IFavorite.class);
        favorite.setCreatedTime(createdTime);
        favorite.setStatusId(statusId);
        favorite.setUserId(userId);
        this.getFavoriteDao().insert(favorite);
        return favorite;
    }

    public int removeFavorite(long statusId, long userId) {
        return this.getFavoriteDao().delete(statusId, userId);
    }

    public IDevice createDevice(IDevice device) {
        this.getDeviceDao().insert(device);
        return device;
    }

    public int updateDevice(IDevice device) {
        return this.getDeviceDao().update(device);
    }

    public IDedicatedClient createClient(String key, String url, String version) {
        IDedicatedClient client = (IDedicatedClient)this.getContainer().getComponent(IDedicatedClient.class);
        client.setText(key);
        client.setUrl(url);
        client.setVersion(version);
        this.getDedicatedClientDao().insert(client);
        this.clientMap_.put(key, client);
        return client;
    }

    public int updateClient(IDedicatedClient client) {
        this.clientMap_.put(client.getText(), client);
        return this.getDedicatedClientDao().update(client);
    }

    public IDedicatedClient getClient(String key) {
        IDedicatedClient client = (IDedicatedClient)this.clientMap_.get(key);
        if (client != null) {
            return client;
        }
        return this.getDedicatedClientDao().findByKey(key);
    }

    public IDedicatedClient[] getClients(String[] texts) {
        ArrayList<IDedicatedClient> clientList = new ArrayList<IDedicatedClient>();
        ArrayList<String> textList = new ArrayList<String>();
        for (String text : texts) {
            IDedicatedClient client = (IDedicatedClient)this.clientMap_.get(text);
            if (client == null) {
                textList.add(text);
                continue;
            }
            clientList.add(client);
        }
        if (textList.size() > 0) {
            IDedicatedClient[] clients;
            texts = textList.toArray(new String[textList.size()]);
            for (IDedicatedClient client : clients = this.getDedicatedClientDao().findAllByText(texts, 0, texts.length)) {
                this.clientMap_.put(client.getText(), client);
                clientList.add(client);
            }
        }
        return clientList.toArray(new IDedicatedClient[clientList.size()]);
    }

    public int removeClient(String text) {
        this.clientMap_.remove(text);
        return this.getDedicatedClientDao().deleteByText(text);
    }

    public void setMessengerWrapperMap(Map<String, IAbstractDeviceWrapper> messengerWrapperMap) {
        this.messengerWrapperMap_ = messengerWrapperMap;
    }

    public IAbstractDeviceWrapper getMessengerWrapper(String deviceType) {
        return (IAbstractDeviceWrapper)this.messengerWrapperMap_.get(deviceType);
    }

    public IAbstractDeviceWrapper[] getMessengerWrappers() {
        Collection messengers = this.messengerWrapperMap_.values();
        return messengers.toArray(new IAbstractDeviceWrapper[messengers.size()]);
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    S2Container getContainer() {
        return this.container_;
    }

    public IStatusDao getStatusDao() {
        return (IStatusDao)this.getContainer().getComponent(IStatusDao.class);
    }

    public IDirectMessageDao getDirectMessageDao() {
        return (IDirectMessageDao)this.getContainer().getComponent(IDirectMessageDao.class);
    }

    public IFavoriteDao getFavoriteDao() {
        return (IFavoriteDao)this.getContainer().getComponent(IFavoriteDao.class);
    }

    public IFriendshipDao getFriendshipDao() {
        return (IFriendshipDao)this.getContainer().getComponent(IFriendshipDao.class);
    }

    public IDeviceDao getDeviceDao() {
        return (IDeviceDao)this.getContainer().getComponent(IDeviceDao.class);
    }

    public IDedicatedClientDao getDedicatedClientDao() {
        return (IDedicatedClientDao)this.getContainer().getComponent(IDedicatedClientDao.class);
    }
}

