/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.service.impl;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.sourceforge.shovel.GrowlType;
import jp.sourceforge.shovel.RepliesType;
import jp.sourceforge.shovel.SortOrderType;
import jp.sourceforge.shovel.SortType;
import jp.sourceforge.shovel.entity.IGrowlPacket;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.interceptor.CsrfInterceptor;
import jp.sourceforge.shovel.logic.IDirectoryLogic;
import jp.sourceforge.shovel.logic.IGrowlLogic;
import jp.sourceforge.shovel.service.IDirectoryService;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;

public class DirectoryServiceImpl
implements IDirectoryService {
    Map<Long, IUser> userMapByPK_ = new HashMap();
    Map<String, IUser> userMapByFK_ = new HashMap();
    String once_;

    void cacheUser(IUser user) {
        if (user != null && this.fetchUser(user.getUserId()) == null) {
            this.userMapByPK_.put(user.getUserId(), user);
            this.userMapByFK_.put(user.getForeignKey(), user);
        }
    }

    void cacheUsers(IUser[] users) {
        for (IUser user : users) {
            this.cacheUser(user);
        }
    }

    void purgeAllUser() {
        this.userMapByPK_.clear();
        this.userMapByFK_.clear();
    }

    void purgeUser(long userId) {
        this.userMapByPK_.remove(userId);
        IUser user = (IUser)this.userMapByPK_.get(userId);
        String foreignKey = user.getForeignKey();
        this.userMapByFK_.remove(foreignKey);
    }

    IUser fetchUser(long userId) {
        return (IUser)this.userMapByPK_.get(userId);
    }

    IUser fetchUser(String foreignKey) {
        return (IUser)this.userMapByFK_.get(foreignKey);
    }

    int correctLimit(int limit) {
        IUser user = this.getLoginUser();
        if (user != null && limit <= 0) {
            limit = user.getViewLines();
        }
        if (limit <= 0 || limit > 20) {
            limit = 20;
        }
        return limit;
    }

    public IUser createUser(String displayName, String foreignKey, String password, String email, IServerFile serverFile, String location, String timeZoneId, String description, boolean protect, boolean cache) throws ApplicationException {
        IUser user;
        if (cache && (user = this.getUser(foreignKey)) != null) {
            throw new ApplicationException("");
        }
        long serverFileId = 0L;
        if (serverFile != null) {
            serverFileId = serverFile.getServerFileId();
        }
        long creatorId = this.getLoginUser().getUserId();
        IUser user2 = this.getDirectoryLogic().createUser(displayName, foreignKey, password, email, serverFileId, location, timeZoneId, description, creatorId, protect);
        return user2;
    }

    public IUser createTemporaryUser() {
        return this.getDirectoryLogic().createTemporaryUser();
    }

    public IUser login(String foreignKey, String password, boolean once) {
        IUser user = null;
        if (foreignKey != null && foreignKey.length() > 0 && (user = this.getUser(foreignKey)) != null && !user.isRemove()) {
            if (password == null) {
                password = "";
            }
            if (password.compareTo(user.getPassword()) == 0) {
                if (once) {
                    this.once_ = user.getForeignKey();
                } else {
                    this.getSession().setAttribute("login", (Object)user.getForeignKey());
                }
                CsrfInterceptor.setCsrfTicket((IUser)user);
            }
        }
        return user;
    }

    public void logout() {
        this.getSession().invalidate();
    }

    public IUser getLoginUser() {
        IUser user;
        String foreignKey = this.once_;
        if (foreignKey == null) {
            foreignKey = (String)this.getSession().getAttribute("login");
        }
        if ((user = this.getUser(foreignKey)) != null && user.isRemove()) {
            return null;
        }
        this.getRequest().setAttribute("loginUser", (Object)user);
        return user;
    }

    public IUser getUser(long userId) {
        IUser user = this.fetchUser(userId);
        if (user == null) {
            user = this.getDirectoryLogic().getUser(userId);
            this.cacheUser(user);
        }
        return user;
    }

    public IUser getUser(String foreignKey) {
        if (foreignKey == null || foreignKey.length() <= 0) {
            return null;
        }
        IUser user = this.fetchUser(foreignKey);
        if (user == null) {
            user = this.getDirectoryLogic().getUserByForeignKey(foreignKey);
            this.cacheUser(user);
        }
        return user;
    }

    public IUser[] getUsers(SortType sortType, SortOrderType sortOrderType, int page) {
        IUser user = this.getLoginUser();
        int limit = 10;
        if (user != null) {
            limit = user.getViewLines();
        }
        IUser[] users = this.getDirectoryLogic().getUsers(sortType, sortOrderType, page * limit, limit + 1);
        this.cacheUsers(users);
        return users;
    }

    public IUser[] getUsers(long[] userIds) {
        IUser[] users = this.getDirectoryLogic().getUsers(userIds);
        this.cacheUsers(users);
        return users;
    }

    public IUser[] getUsers(String[] foreignKeys) {
        IUser[] users = this.getDirectoryLogic().getUsers(foreignKeys);
        this.cacheUsers(users);
        return users;
    }

    public IUser[] searchUsers(String keyword, int page, int limit) {
        limit = this.correctLimit(limit);
        IUser[] users = this.getDirectoryLogic().searchUsers(keyword, page * limit, limit + 1);
        this.cacheUsers(users);
        return users;
    }

    public IUser[] getRandUsers() {
        IUser[] users = this.getDirectoryLogic().getRandUsers(false, 0, 10);
        this.cacheUsers(users);
        return users;
    }

    public int removeUser(long userId) throws ApplicationException {
        return this.removeUsers(new long[]{userId});
    }

    public int removeUsers(long[] userIds) {
        return this.getDirectoryLogic().updateRemove(userIds);
    }

    public int updateUser(IUser user) throws ApplicationException {
        return this.getDirectoryLogic().updateUser(user);
    }

    public int updateUserFromImportCsv(IUser user) throws ApplicationException {
        return this.getDirectoryLogic().updateUserFromImportCsv(user);
    }

    public int updateUserFromSettings(IUser user) throws ApplicationException {
        return this.getDirectoryLogic().updateUserFromSettings(user);
    }

    public int updatePassword(String password) {
        IUser user = this.getLoginUser();
        return this.getDirectoryLogic().updatePassword(user.getUserId(), password);
    }

    public int updatePicture(long serverFileId) {
        IUser user = this.getLoginUser();
        return this.getDirectoryLogic().updatePicture(user.getUserId(), serverFileId);
    }

    public int updateNotices(RepliesType repliesType, boolean growl, String growlHost, String growlPassword) throws ApplicationException {
        if (growl) {
            IGrowlPacket packet = this.getGrowlLogic().createPacket("Shovel", GrowlType.REGISTRATION, growlPassword);
            packet.addNotification("Updated Status", true);
            packet.addNotification("Received Direct Message", true);
            this.getGrowlLogic().sendPacket(growlHost, packet);
        }
        IUser user = this.getLoginUser();
        return this.getDirectoryLogic().updateNotices(user.getUserId(), repliesType, growl, growlHost, growlPassword);
    }

    public int incrementFavorites(String foreignKey) {
        return this.getDirectoryLogic().incrementFavorites(foreignKey);
    }

    public int incrementGivenFavorites(long userId) {
        return this.getDirectoryLogic().incrementGivenFavorites(userId);
    }

    public int incrementDirectMessages(String foreignKey) {
        return this.getDirectoryLogic().incrementDirectMessages(foreignKey);
    }

    public int incrementStatuses(String foreignKey) {
        return this.getDirectoryLogic().incrementStatus(foreignKey);
    }

    public int decrementFavorites(String foreignKey) {
        return this.getDirectoryLogic().decrementFavorites(foreignKey);
    }

    public int decrementFavoritesByStatus(long statusId) {
        return this.getDirectoryLogic().decrementFavoritesByStatus(statusId);
    }

    public int decrementGivenFavorites(long userId) {
        return this.getDirectoryLogic().decrementGivenFavorites(userId);
    }

    public int decrementStatuses(String foreignKey) {
        return this.getDirectoryLogic().decrementStatus(foreignKey);
    }

    public int decrementDirectMessages(String foreignKey) {
        return this.getDirectoryLogic().decrementDirectMessages(foreignKey);
    }

    S2Container getContainer() {
        return SingletonS2ContainerFactory.getContainer();
    }

    HttpSession getSession() {
        return (HttpSession)this.getContainer().getComponent((Object)"session");
    }

    HttpServletRequest getRequest() {
        return (HttpServletRequest)this.getContainer().getComponent((Object)"request");
    }

    IDirectoryLogic getDirectoryLogic() {
        return (IDirectoryLogic)this.getContainer().getComponent(IDirectoryLogic.class);
    }

    IGrowlLogic getGrowlLogic() {
        return (IGrowlLogic)this.getContainer().getComponent(IGrowlLogic.class);
    }
}

