/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.taglib;

import freemarker.template.utility.StringUtil;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import jp.sourceforge.shovel.taglib.AutoFormatTag;
import org.seasar.framework.container.S2Container;

public class AutoFormatTag
extends TagSupport {
    static final long serialVersionUID = -1L;
    S2Container container_;
    String data_;
    boolean popup_;
    int length_ = 200;
    int maxUrl_ = 40;
    String url_;
    int tabSpace_;
    static final String URL = "https?://[a-zA-Z0-9/_.?#&;=$+:@%~,\\-]+";
    static final String REPLY = "[^\\w]?@([\\w|-]+)";
    static final String POPUP = " target=\"_blank\"";
    static final String SUFFIX = "...";

    public String getData() {
        return this.data_;
    }

    public void setData(String data) {
        this.data_ = data;
    }

    public boolean isPopup() {
        return this.popup_;
    }

    public void setPopup(boolean popup) {
        this.popup_ = popup;
    }

    public int getLength() {
        return this.length_;
    }

    public void setLength(int length) {
        this.length_ = length;
    }

    public String getUrl() {
        return this.url_;
    }

    public void setUrl(String url) {
        this.url_ = url;
    }

    public int getMaxUrl() {
        return this.maxUrl_;
    }

    public void setMaxUrl(int maxUrl) {
        this.maxUrl_ = maxUrl;
    }

    SortedMap getMatches(Map map, int type, String pattern, String body, int group) {
        TreeMap<Long, Match> matchMap = map == null ? new TreeMap<Long, Match>() : (TreeMap<Long, Match>)map;
        Matcher matcher = Pattern.compile(pattern).matcher(body);
        while (matcher.find()) {
            Match match = new Match(this);
            match.setType(type);
            match.setStart(matcher.start(group));
            match.setEnd(matcher.end(group));
            int groupCount = matcher.groupCount();
            ArrayList<String> regs = new ArrayList<String>();
            for (int i = 0; i <= groupCount; ++i) {
                regs.add(matcher.group(i));
            }
            match.setRegs(regs);
            matchMap.put(Long.valueOf(matcher.start()), match);
        }
        return matchMap;
    }

    String truncateString(String data, String encoding, int length, boolean contain) {
        try {
            byte[] bytes = data.getBytes(encoding);
            if (bytes.length > length) {
                if (contain) {
                    length -= SUFFIX.length();
                }
                int i = 0;
                boolean fin = false;
                do {
                    byte b;
                    int unsigned;
                    if ((unsigned = (b = bytes[i]) & 0xFF) >= 129 && unsigned <= 159 || unsigned >= 224 && unsigned <= 252) {
                        if ((i += 2) <= length) continue;
                        i -= 2;
                        fin = true;
                        continue;
                    }
                    ++i;
                } while (i < length && !fin);
                byte[] newBytes = new byte[i];
                System.arraycopy(bytes, 0, newBytes, 0, i);
                return new String(newBytes, encoding);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public int doEndTag() throws JspException {
        if (this.data_ != null && this.data_.length() > 0) {
            String popup = this.isPopup() ? POPUP : "";
            String truncatedData = this.data_;
            boolean truncated = false;
            if (this.length_ > 0) {
                truncatedData = this.truncateString(this.data_, "Windows-31J", this.length_, false);
                if (this.data_.length() > truncatedData.length()) {
                    truncated = true;
                }
            }
            TreeMap<Long, Match> matchMap = new TreeMap<Long, Match>();
            this.getMatches(matchMap, 0, URL, this.data_, 0);
            this.getMatches(matchMap, 1, REPLY, this.data_, 1);
            matchMap.put(Long.valueOf(this.data_.length()), new Match(this, 4, this.data_.length(), 0));
            Match[] matches = matchMap.values().toArray(new Match[matchMap.size()]);
            try {
                int i = 0;
                StringBuilder data = new StringBuilder();
                for (Match match : matches) {
                    int start = match.getStart();
                    if (start < i) continue;
                    String[] regs = match.getRegs();
                    if (start - i > 0) {
                        if (truncatedData.length() <= start) {
                            start = truncatedData.length();
                            data.append(StringUtil.HTMLEnc((String)this.data_.substring(i, start)));
                            break;
                        }
                        data.append(StringUtil.HTMLEnc((String)this.data_.substring(i, start)));
                    }
                    int end = match.getEnd();
                    if (truncatedData.length() < end) {
                        end = truncatedData.length();
                    }
                    String token = truncatedData.substring(match.getStart(), end);
                    token = StringUtil.HTMLEnc((String)token);
                    switch (match.getType()) {
                        case 0: {
                            StringBuilder builder = new StringBuilder();
                            try {
                                URI uri = URI.create(regs[0]);
                                builder.append(uri.toString());
                            }
                            catch (Exception e) {
                                int pos = regs[0].indexOf("?");
                                if (pos < 0 || pos == regs[0].length() - 1) {
                                    builder.append(regs[0]);
                                }
                                builder.append(regs[0].substring(0, pos));
                                builder.append("?");
                                String query = regs[0].substring(pos + 1);
                                builder.append(StringUtil.URLEnc((String)query, (String)"UTF-8"));
                            }
                            if (token.length() > this.maxUrl_) {
                                token = token.substring(0, this.maxUrl_);
                                token = token + SUFFIX;
                            }
                            data.append("<a href=\"");
                            data.append(builder.toString());
                            data.append("\"");
                            data.append(popup);
                            data.append(">");
                            data.append(token);
                            data.append("</a>");
                            break;
                        }
                        case 1: {
                            String foreignKey = StringUtil.HTMLEnc((String)regs[1]);
                            data.append("<a href=\"/");
                            data.append(foreignKey);
                            data.append("\">");
                            data.append(token);
                            data.append("</a>");
                            break;
                        }
                    }
                    i = start + match.getLength();
                    if (truncatedData.length() < i) break;
                }
                if (truncated) {
                    if (this.url_ == null || this.url_.length() <= 0) {
                        data.append(SUFFIX);
                    } else {
                        data.append("<a href=\"" + this.url_ + "\">");
                        data.append(SUFFIX);
                        data.append("</a>");
                    }
                }
                this.pageContext.getOut().print(data.toString());
            }
            catch (Exception e) {
                throw new JspException(e.getMessage());
            }
        }
        return 6;
    }
}

