/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.shovel.exception.ApplicationException;

public class ShovelUtil {
    public static final int VALIDATION = 0;
    public static final int EMPTY_DISPLAYNAME = 1;
    public static final int EMPTY_FOREIGNKEY = 2;
    public static final int PROHIBIT_CHAR = 3;
    public static final int PROHIBIT_SUFFIX = 4;
    public static final int RESERVED_FOREINGKEY = 5;
    public static final int INVALID_EMAIL = 6;
    static final String emailPattern_ = "^[^@]+@[^.]+\\..+";
    static final String prohibitChar_ = "[^\\w\\.\\=]";
    static final String prohibitSuffix_ = "(\\.(atom|do|ftl|json|rss|xml))$";
    static final String reservedFK_ = "^(login|logout|home|replies|public_timeline|friends|followers|friend_requests|favorites|device|system)$";

    public static int validateUser(String displayName, String foreignKey, String email, boolean retval) throws ApplicationException {
        if (displayName != null && (displayName = displayName.trim()).length() <= 0) {
            if (retval) {
                return 1;
            }
            throw new ApplicationException("");
        }
        if (foreignKey != null) {
            if ((foreignKey = foreignKey.trim()).length() <= 0) {
                if (retval) {
                    return 2;
                }
                throw new ApplicationException("");
            }
            Pattern pattern = Pattern.compile(prohibitChar_);
            Matcher matcher = pattern.matcher(foreignKey);
            if (matcher.find()) {
                if (retval) {
                    return 3;
                }
                throw new ApplicationException("");
            }
            pattern = Pattern.compile(prohibitSuffix_);
            matcher = pattern.matcher(foreignKey);
            if (matcher.find()) {
                if (retval) {
                    return 4;
                }
                throw new ApplicationException("");
            }
            pattern = Pattern.compile(reservedFK_);
            matcher = pattern.matcher(foreignKey);
            if (matcher.find()) {
                if (retval) {
                    return 5;
                }
                throw new ApplicationException("");
            }
        }
        if (email != null && (email = email.trim()).length() > 0 && !email.matches(emailPattern_)) {
            if (retval) {
                return 6;
            }
            throw new ApplicationException("");
        }
        return 0;
    }
}

