/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.xa;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import jp.sourceforge.shovel.SizeType;
import jp.sourceforge.shovel.entity.IServerFile;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.xa.XAServerFile;
import org.seasar.extension.jta.xa.DefaultXAResource;
import org.seasar.framework.exception.SXAException;

public class XAServerFile
extends DefaultXAResource {
    String root_;
    List<IServerFile> copies_;
    List<IServerFile> removes_;
    List<Work> works_;

    public void setCommonProperties(Properties commonProperties) throws ApplicationException {
        this.root_ = commonProperties.getProperty("files.dir");
        File dir = new File(this.root_);
        if (!dir.isDirectory() || !dir.canWrite()) {
            ApplicationException ex = new ApplicationException("");
            ex.setCauseArgs(dir.getPath());
            throw ex;
        }
    }

    protected void doBegin(Xid xid) throws XAException {
    }

    protected void doCommit(Xid xid, boolean onePhase) throws XAException {
    }

    protected int doPrepare(Xid xid) throws XAException {
        try {
            if (this.copies_ != null) {
                for (IServerFile copy : this.copies_) {
                    copy.commit(0);
                }
            }
            if (this.removes_ != null) {
                for (IServerFile remove : this.removes_) {
                    remove.commit(1);
                }
            }
            if (this.works_ != null) {
                for (Work work : this.works_) {
                    work.commit();
                }
            }
            return 0;
        }
        catch (Exception e) {
            throw new SXAException((Throwable)e);
        }
    }

    protected void doRollback(Xid xid) throws XAException {
        try {
            if (this.copies_ != null) {
                this.copies_.clear();
            }
            if (this.removes_ != null) {
                this.removes_.clear();
            }
            if (this.works_ != null) {
                this.works_.clear();
            }
        }
        catch (Exception e) {
            throw new SXAException((Throwable)e);
        }
    }

    public void addToCopy(IServerFile serverFile) {
        if (this.copies_ == null) {
            this.copies_ = new ArrayList();
        }
        this.copies_.add(serverFile);
    }

    public void addToRemove(IServerFile serverFile) {
        if (this.removes_ == null) {
            this.removes_ = new ArrayList();
        }
        this.removes_.add(serverFile);
    }

    public void addToWork(IServerFile serverFile, SizeType sizeType) {
        if (this.works_ == null) {
            this.works_ = new ArrayList();
        }
        Work work = new Work(this);
        work.setServerFile(serverFile);
        work.setSizeType(sizeType);
        this.works_.add(work);
    }
}

