<#if !users?has_content>
<?xml version="1.0" encoding="UTF-8"?>
</#if>
<#assign common=JspTaglibs["/WEB-INF/tld/common.tld"] />
<#import "/macro.ftl" as macro />
<#if statuses?has_content>
  <#assign status=statuses[user.userId?string]?default("") />
</#if>
<user>
  <id>${user.userId}</id>
  <name><@common.ncrEncode data=user.displayName /></name>
<#if user.location?has_content>
  <location><@common.ncrEncode data=user.location /></location>
<#else>
  <location />
</#if>
<#if user.description?has_content>
  <description><@common.ncrEncode data=user.description /></description>
<#else>
  <description />
</#if>
  <profile_image_url><@macro.userThumbnailUrl user=user /></profile_image_url>
  <given_favorites_count>${user.givenFavorites}</given_favorites_count>
  <friends_count>${user.following}</friends_count>
  <followers_count>${user.followers}</followers_count>
  <favourites_count>${user.favorites}</favourites_count>
  <statuses_count>${user.statuses}</statuses_count>
<#if status?has_content>
  <status>
    <created_at><#rt />
  <@common.dateFormat date=status.sentTime format="dateTime.compatible.twitter" timeZoneID="UTC" lang="en" /><#t />
    </created_at><#lt />
    <id>${status.statusId}</id>
    <text><@common.ncrEncode data=status.body /></text>
    <source><@macro.sourceWithLink source=status.source dedicatedClient=status.dedicatedClient escape="xml" /></source>
    <truncated>false</truncated>
  <#if status.referenceId &gt; 0>
    <in_reply_to_status_id>${status.referenceId}</in_reply_to_status_id>
    <in_reply_to_user_id>${status.referenceSenderId}</in_reply_to_user_id>
  <#else>
    <in_reply_to_status_id />
    <in_reply_to_user_id />
  </#if>
    <favorited><#rt />
  <#if status.favorite?has_content>
      true<#t />
  <#else>
      false<#t />
  </#if>
    </favorited><#lt />
    <given_favorites_count>${status.givenFavorites}</given_favorites_count>
  </status>
<#else>
  <status />
</#if>
</user>
