/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.shovel.action.impl;

import java.util.Properties;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.sourceforge.shovel.AccountConfigType;
import jp.sourceforge.shovel.action.IAccountAction;
import jp.sourceforge.shovel.action.impl.AccountActionImpl;
import jp.sourceforge.shovel.annotation.Perform;
import jp.sourceforge.shovel.device.IDelayExecutor;
import jp.sourceforge.shovel.entity.IDevice;
import jp.sourceforge.shovel.entity.IUser;
import jp.sourceforge.shovel.exception.ApplicationException;
import jp.sourceforge.shovel.form.IAccountForm;
import jp.sourceforge.shovel.service.IDirectoryService;
import jp.sourceforge.shovel.service.IShovelService;
import jp.sourceforge.shovel.thread.DelayExecutorQueue;
import jp.sourceforge.shovel.util.HttpUtil;
import jp.sourceforge.shovel.util.ShovelUtil;
import org.seasar.framework.container.S2Container;

public class AccountActionImpl
implements IAccountAction {
    IAccountForm actionForm_;
    ServletContext context_;
    HttpServletRequest request_;
    HttpServletResponse response_;
    S2Container container_;
    DelayExecutorQueue queue_;

    @Perform(CSRF=false, login=false)
    public String perform() throws Exception {
        IShovelService shovelService = this.getShovelService();
        IDirectoryService directoryService = shovelService.getDirectoryService();
        IUser user = directoryService.getLoginUser();
        AccountConfigType configType = this.actionForm_.getConfigType();
        if (configType.isDevice() && !((Boolean)this.context_.getAttribute("device")).booleanValue()) {
            HttpUtil.sendRedirect((HttpServletResponse)this.response_, (String)"/account/settings");
            return null;
        }
        if (!(configType.isProfileImage() || configType.isResendPassword() || configType.isResetPassword() || user != null)) {
            HttpUtil.sendRedirect((HttpServletResponse)this.response_, (String)"/");
            return null;
        }
        switch (1.$SwitchMap$jp$sourceforge$shovel$AccountConfigType[configType.ordinal()]) {
            case 1: {
                String[] tzIDs = TimeZone.getAvailableIDs();
                TimeZone[] tzs = new TimeZone[tzIDs.length];
                int i = 0;
                for (String tzID : tzIDs) {
                    tzs[i++] = TimeZone.getTimeZone(tzID);
                }
                this.request_.setAttribute("tzs", (Object)tzs);
                break;
            }
            case 2: {
                IDevice device = user.getDevice();
                if (device.getDeviceType().isUnknown()) break;
                IDelayExecutor executor = this.queue_.getDelayExecutor(device.getType());
                if (executor == null) {
                    this.getShovelService().resetDevice();
                    break;
                }
                this.request_.setAttribute("address", (Object)executor.getAddress());
                this.request_.setAttribute("releaseKey", (Object)user.getReleaseKey());
                break;
            }
            case 3: {
                Properties props = (Properties)this.container_.getComponent((Object)"commonProperties");
                String maxSize = props.getProperty("upload.maxSize");
                this.request_.setAttribute("maxSize", (Object)Integer.parseInt(maxSize));
                break;
            }
            case 4: {
                user = directoryService.getUser(this.actionForm_.getForeignKey());
                break;
            }
            case 5: {
                long backgroundImageId = user.getBackgroundImageId();
                if (backgroundImageId > 0L) break;
                user.setTile(true);
                break;
            }
            case 6: {
                user = directoryService.getUser(this.actionForm_.getEmail(), true);
                String token = ShovelUtil.generateToken((String)(this.actionForm_.getEmail() + ":" + user.getPassword()));
                if (token.compareTo(this.actionForm_.getToken()) != 0) {
                    throw new ApplicationException("");
                }
                this.request_.setAttribute("email", (Object)this.actionForm_.getEmail());
                this.request_.setAttribute("token", (Object)this.actionForm_.getToken());
            }
        }
        shovelService.prepareForView(user);
        this.request_.setAttribute("domain", (Object)this.request_.getServerName());
        this.request_.setAttribute("port", (Object)this.request_.getServerPort());
        this.request_.setAttribute("config", (Object)configType);
        this.request_.setAttribute("user", (Object)user);
        return this.actionForm_.isPartial() ? configType.getForward() : "account";
    }

    public void setContainer(S2Container container) {
        this.container_ = container;
    }

    public void setContext(ServletContext context) {
        this.context_ = context;
    }

    public void setAccountForm(IAccountForm actionForm) {
        this.actionForm_ = actionForm;
    }

    public void setRequest(HttpServletRequest request) {
        this.request_ = request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response_ = response;
    }

    public void setDelayExecutorQueue(DelayExecutorQueue queue) {
        this.queue_ = queue;
    }

    public IShovelService getShovelService() {
        return (IShovelService)this.request_.getAttribute("shovelService");
    }
}

